/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.io;

import gabien.uslx.io.ImmutableChecksum32;

public final class CRC32Forward
implements ImmutableChecksum32 {
    public final int polynomial;
    private final int[] crc32tab = new int[256];
    public static final CRC32Forward CRC32_04C11DB7 = new CRC32Forward(79764919);

    public CRC32Forward(int p) {
        this.polynomial = p;
        for (int i = 0; i < this.crc32tab.length; ++i) {
            int crc = i << 24;
            for (int j = 0; j < 8; ++j) {
                if (crc < 0) {
                    crc = crc << 1 ^ p;
                    continue;
                }
                crc <<= 1;
            }
            this.crc32tab[i] = crc;
        }
    }

    @Override
    public int update(int v, byte[] data, int offset, int length) {
        while (length > 0) {
            int lb = data[offset++] & 0xFF ^ v >>> 24;
            v = this.crc32tab[lb] ^ v << 8;
            --length;
        }
        return v;
    }

    @Override
    public int update(int v, byte b) {
        int lb = b & 0xFF ^ v >>> 24;
        v = this.crc32tab[lb] ^ v << 8;
        return v;
    }
}

