/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TimeLogger
implements AutoCloseable {
    private DataOutputStream output;
    private int nextSourceID;
    private ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue(256);
    private Thread runner = new Thread("TimeLogger"){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ((Runnable)TimeLogger.this.queue.take()).run();
                    }
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    continue;
                }
                break;
            }
        }
    };

    public TimeLogger(OutputStream os) {
        this.output = new DataOutputStream(os);
        this.runner.start();
    }

    @Nullable
    public static Source optSource(@Nullable TimeLogger logger, String name) {
        if (logger == null) {
            return null;
        }
        return logger.newSource(name);
    }

    @Nullable
    public static Source open(@Nullable Source src) {
        if (src == null) {
            return null;
        }
        return src.open();
    }

    public static void close(@Nullable Source src) {
        if (src == null) {
            return;
        }
        src.close();
    }

    private synchronized void event(int type, int sourceID, @Nullable String addendum, long now) {
        if (this.output == null) {
            return;
        }
        try {
            this.output.write(type);
            this.output.writeInt(sourceID);
            this.output.writeLong(now);
            if (addendum != null) {
                this.output.writeUTF(addendum);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized Source newSource(@NonNull String id) {
        int sid = this.nextSourceID++;
        long now = System.nanoTime();
        this.queue.add(() -> this.event(0, sid, id, now));
        return new Source(sid);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }

    protected synchronized void finalize() throws IOException {
        this.close();
    }

    public synchronized void flush() {
        if (this.output != null) {
            try {
                this.output.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class Source
    implements AutoCloseable {
        public final int id;

        public Source(int id) {
            this.id = id;
        }

        private Source open() {
            try {
                long now = System.nanoTime();
                TimeLogger.this.queue.put(() -> TimeLogger.this.event(1, this.id, null, now));
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            return this;
        }

        @Override
        @Deprecated
        public void close() {
            try {
                long now = System.nanoTime();
                TimeLogger.this.queue.put(() -> TimeLogger.this.event(2, this.id, null, now));
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }
}

