/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

import gabien.uslx.append.Block;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ThreadOwned {
    @Nullable
    private volatile Thread boundThread = Thread.currentThread();

    public final void assertBound() {
        Thread sample = this.boundThread;
        if (sample != Thread.currentThread()) {
            if (sample == null) {
                throw new RuntimeException("A request was made from " + Thread.currentThread() + " while the instance was not bound.");
            }
            throw new RuntimeException("A request was made from " + Thread.currentThread() + " while the instance was bound to " + sample + ".");
        }
    }

    protected void bindImpl() {
    }

    protected void unbindImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bind() {
        ThreadOwned threadOwned = this;
        synchronized (threadOwned) {
            Thread otherThread = this.boundThread;
            if (otherThread != null) {
                throw new RuntimeException("Cannot transfer to " + Thread.currentThread() + ", as the object is owned by " + otherThread + ".");
            }
            this.boundThread = Thread.currentThread();
        }
        try {
            this.bindImpl();
        }
        catch (Throwable t) {
            this.boundThread = null;
            throw t;
        }
    }

    public final void unbind() {
        this.assertBound();
        this.unbindImpl();
        this.boundThread = null;
    }

    public static final class Locked
    implements Block {
        @NonNull
        public final ThreadOwned underlying;
        @NonNull
        private final ReentrantLock lock = new ReentrantLock(true);

        public Locked(@NonNull ThreadOwned base) {
            base.assertBound();
            this.underlying = base;
            this.lock.lock();
        }

        public Locked open() {
            boolean actuallyBind = !this.lock.isHeldByCurrentThread();
            this.lock.lock();
            if (actuallyBind) {
                try {
                    this.underlying.bind();
                }
                catch (Throwable t) {
                    this.lock.unlock();
                    throw t;
                }
            }
            return this;
        }

        @Override
        public void close() {
            if (this.lock.getHoldCount() == 1) {
                this.underlying.unbind();
            }
            this.lock.unlock();
        }
    }
}

