/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

import java.lang.reflect.Array;

public abstract class TemporaryResultsBuffer<T> {
    private final ThreadLocal<T> threadLocal = new ThreadLocal();

    public T get() {
        T res = this.threadLocal.get();
        if (res == null) {
            res = this.make();
            this.threadLocal.set(res);
        }
        return res;
    }

    protected abstract T make();

    public static final class F64
    extends Ar<double[]> {
        public F64(int len) {
            super(len, Double.TYPE);
        }
    }

    public static final class F32
    extends Ar<float[]> {
        public F32(int len) {
            super(len, Float.TYPE);
        }
    }

    public static final class I64
    extends Ar<long[]> {
        public I64(int len) {
            super(len, Long.TYPE);
        }
    }

    public static final class I32
    extends Ar<int[]> {
        public I32(int len) {
            super(len, Integer.TYPE);
        }
    }

    public static final class I16
    extends Ar<short[]> {
        public I16(int len) {
            super(len, Short.TYPE);
        }
    }

    public static final class I8
    extends Ar<byte[]> {
        public I8(int len) {
            super(len, Byte.TYPE);
        }
    }

    public static abstract class Ar<T>
    extends TemporaryResultsBuffer<T> {
        public final int length;
        public final Class componentType;

        public Ar(int len, Class c) {
            this.length = len;
            this.componentType = c;
        }

        @Override
        protected T make() {
            return (T)Array.newInstance(this.componentType, this.length);
        }
    }
}

