/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public final class RefSyncSet<T>
implements Iterable<T> {
    private final HashSet<Reference<Holder>> held = new HashSet();

    private synchronized void fill(Collection<T> c) {
        for (Reference<Holder> rh : this.held) {
            Holder h = rh.get();
            if (h == null) continue;
            c.add(h.value);
        }
    }

    public synchronized ArrayList<T> toArrayList() {
        ArrayList lst = new ArrayList(this.held.size());
        this.fill(lst);
        return lst;
    }

    @Override
    public Iterator<T> iterator() {
        return this.toArrayList().iterator();
    }

    public synchronized Holder addWeak(T object) {
        Holder h = new Holder(object);
        this.held.add(h.thisRef);
        return h;
    }

    public synchronized void remove(Holder object) {
        this.held.remove(object.thisRef);
    }

    public final class Holder {
        public final T value;
        private final Reference<Holder> thisRef;

        Holder(T obj) {
            this.value = obj;
            this.thisRef = new WeakReference<Holder>(this);
        }

        protected void finalize() throws Throwable {
            RefSyncSet.this.remove(this);
        }
    }
}

