/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

import gabien.uslx.append.Rect;
import gabien.uslx.append.TemporaryResultsBuffer;

public final class RectIntersector {
    public static final TemporaryResultsBuffer<RectIntersector> THREAD_LOCAL = new TemporaryResultsBuffer<RectIntersector>(){

        @Override
        protected RectIntersector make() {
            return new RectIntersector();
        }
    };
    public int x;
    public int y;
    public int width;
    public int height;

    public void set(Rect viewRct) {
        this.set(viewRct.x, viewRct.y, viewRct.width, viewRct.height);
    }

    public void set(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean intersect(Rect r) {
        return this.intersect(r.x, r.y, r.width, r.height);
    }

    public boolean intersect(int bx, int by, int bw, int bh) {
        if (RectIntersector.intersects1i(bx, bw, this.x, this.width)) {
            int xStart = Math.max(bx, this.x);
            int xW = RectIntersector.intersect1iWidth(bx, bw, this.x, this.width, xStart);
            this.x = xStart;
            this.width = xW;
            if (RectIntersector.intersects1i(by, bh, this.y, this.height)) {
                int yStart = Math.max(by, this.y);
                int yH = RectIntersector.intersect1iWidth(by, bh, this.y, this.height, yStart);
                this.y = yStart;
                this.height = yH;
                return true;
            }
            this.height = 0;
        } else {
            this.width = 0;
            this.height = 0;
        }
        return false;
    }

    public static boolean intersects1i(int A, int AL, int B, int BL) {
        if (AL <= 0) {
            return false;
        }
        if (BL <= 0) {
            return false;
        }
        if (A >= B && A < B + BL) {
            return true;
        }
        return B >= A && B < A + AL;
    }

    public static int intersect1iWidth(int A, int AL, int B, int BL, int start) {
        return Math.min(A + AL, B + BL) - start;
    }
}

