/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

import gabien.uslx.append.RectIntersector;
import gabien.uslx.append.Size;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Rect
extends Size {
    public static final Rect ZERO = new Rect(0, 0, 0, 0);
    public final int x;
    public final int y;
    public final int right;
    public final int bottom;

    public Rect(int x, int y, int w, int h) {
        super(w, h);
        this.x = x;
        this.y = y;
        this.right = x + w;
        this.bottom = y + h;
    }

    public Rect(@NonNull Size size) {
        this(0, 0, size.width, size.height);
    }

    @Override
    public String toString() {
        return this.x + "," + this.y + "," + super.toString();
    }

    public boolean rectEquals(@NonNull Rect o) {
        return this.sizeEquals(o) && o.x == this.x && o.y == this.y;
    }

    public boolean contains(int x, int y) {
        return x >= this.x && y >= this.y && x < this.right && y < this.bottom;
    }

    public boolean intersects(@NonNull Rect rect) {
        return rect.x < this.right && rect.right > this.x && rect.y < this.bottom && rect.bottom > this.y;
    }

    @Nullable
    public Rect getIntersection(@NonNull Rect rect) {
        if (RectIntersector.intersects1i(rect.x, rect.width, this.x, this.width)) {
            int xStart = Math.max(rect.x, this.x);
            int xW = RectIntersector.intersect1iWidth(rect.x, rect.width, this.x, this.width, xStart);
            if (RectIntersector.intersects1i(rect.y, rect.height, this.y, this.height)) {
                int yStart = Math.max(rect.y, this.y);
                int yH = RectIntersector.intersect1iWidth(rect.y, rect.height, this.y, this.height, yStart);
                return new Rect(xStart, yStart, xW, yH);
            }
        }
        return null;
    }

    @NonNull
    public Rect margin(int l, int u, int r, int d) {
        return new Rect(this.x + l, this.y + u, this.width - (l + r), this.height - (u + d));
    }

    @NonNull
    public Rect transformed(Rect from, Rect to) {
        if (from.width == 0 || from.height == 0) {
            return new Rect(this.x + (to.x - from.x), this.y + (to.y - from.y), 0, 0);
        }
        if (this.width == from.width && this.height == from.height) {
            return new Rect(this.x + (to.x - from.x), this.y + (to.y - from.y), to.width, to.height);
        }
        if (to.width == from.width && to.height == from.height) {
            return new Rect(this.x + (to.x - from.x), this.y + (to.y - from.y), this.width, this.height);
        }
        double selfFromRatioW = (double)this.width / (double)from.width;
        double selfFromRatioH = (double)this.height / (double)from.height;
        return new Rect(this.x + (int)((double)(to.x - from.x) * selfFromRatioW), this.y + (int)((double)(to.y - from.y) * selfFromRatioH), (int)((double)to.width * selfFromRatioW), (int)((double)to.height * selfFromRatioH));
    }

    public Rect multiplied(int tileSize) {
        return new Rect(this.x * tileSize, this.y * tileSize, this.width * tileSize, this.height * tileSize);
    }
}

