/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

public abstract class PrimStack {
    protected int size;
    protected int sp;
    private int watermark;

    private PrimStack() {
    }

    abstract void resize(int var1);

    public void cycle() {
        this.resize(this.watermark);
        this.watermark = this.sp;
    }

    public void clear() {
        this.sp = 0;
        this.resize(0);
    }

    protected int getPushIndex(int amount) {
        int index = this.sp;
        this.sp += amount;
        if (this.sp > this.size) {
            this.resize(this.sp);
        }
        this.watermark = Math.max(this.sp, this.watermark);
        return index;
    }

    public static class F64
    extends PrimStack {
        private double[] data = new double[0];

        @Override
        void resize(int size) {
            double[] nv = new double[size];
            System.arraycopy(this.data, 0, nv, 0, Math.min(this.data.length, size));
            this.data = nv;
            this.size = size;
        }

        public double pop() {
            return this.data[--this.sp];
        }

        public void pop(double[] a, int offset, int length) {
            this.sp -= length;
            System.arraycopy(this.data, this.sp, a, offset, length);
        }

        public void push(double v) {
            int idx = this.getPushIndex(1);
            this.data[idx] = v;
        }

        public void push(double[] a, int offset, int length) {
            int idx = this.getPushIndex(length);
            System.arraycopy(a, offset, this.data, idx, length);
        }
    }

    public static class F32
    extends PrimStack {
        private float[] data = new float[0];

        @Override
        void resize(int size) {
            float[] nv = new float[size];
            System.arraycopy(this.data, 0, nv, 0, Math.min(this.data.length, size));
            this.data = nv;
            this.size = size;
        }

        public float pop() {
            return this.data[--this.sp];
        }

        public void pop(float[] a, int offset, int length) {
            this.sp -= length;
            System.arraycopy(this.data, this.sp, a, offset, length);
        }

        public void push(float v) {
            int idx = this.getPushIndex(1);
            this.data[idx] = v;
        }

        public void push(float[] a, int offset, int length) {
            int idx = this.getPushIndex(length);
            System.arraycopy(a, offset, this.data, idx, length);
        }
    }

    public static class I64
    extends PrimStack {
        private long[] data = new long[0];

        @Override
        void resize(int size) {
            long[] nv = new long[size];
            System.arraycopy(this.data, 0, nv, 0, Math.min(this.data.length, size));
            this.data = nv;
            this.size = size;
        }

        public long pop() {
            return this.data[--this.sp];
        }

        public void pop(long[] a, int offset, int length) {
            this.sp -= length;
            System.arraycopy(this.data, this.sp, a, offset, length);
        }

        public void push(long v) {
            int idx = this.getPushIndex(1);
            this.data[idx] = v;
        }

        public void push(long[] a, int offset, int length) {
            int idx = this.getPushIndex(length);
            System.arraycopy(a, offset, this.data, idx, length);
        }
    }

    public static class I32
    extends PrimStack {
        private int[] data = new int[0];

        @Override
        void resize(int size) {
            int[] nv = new int[size];
            System.arraycopy(this.data, 0, nv, 0, Math.min(this.data.length, size));
            this.data = nv;
            this.size = size;
        }

        public int pop() {
            return this.data[--this.sp];
        }

        public void pop(int[] a, int offset, int length) {
            this.sp -= length;
            System.arraycopy(this.data, this.sp, a, offset, length);
        }

        public void push(int v) {
            int idx = this.getPushIndex(1);
            this.data[idx] = v;
        }

        public void push(int[] a, int offset, int length) {
            int idx = this.getPushIndex(length);
            System.arraycopy(a, offset, this.data, idx, length);
        }
    }

    public static class U16
    extends PrimStack {
        private char[] data = new char[0];

        @Override
        void resize(int size) {
            char[] nv = new char[size];
            System.arraycopy(this.data, 0, nv, 0, Math.min(this.data.length, size));
            this.data = nv;
            this.size = size;
        }

        public char pop() {
            return this.data[--this.sp];
        }

        public void pop(char[] a, int offset, int length) {
            this.sp -= length;
            System.arraycopy(this.data, this.sp, a, offset, length);
        }

        public void push(char v) {
            int idx = this.getPushIndex(1);
            this.data[idx] = v;
        }

        public void push(char[] a, int offset, int length) {
            int idx = this.getPushIndex(length);
            System.arraycopy(a, offset, this.data, idx, length);
        }
    }

    public static class I16
    extends PrimStack {
        private short[] data = new short[0];

        @Override
        void resize(int size) {
            short[] nv = new short[size];
            System.arraycopy(this.data, 0, nv, 0, Math.min(this.data.length, size));
            this.data = nv;
            this.size = size;
        }

        public short pop() {
            return this.data[--this.sp];
        }

        public void pop(short[] a, int offset, int length) {
            this.sp -= length;
            System.arraycopy(this.data, this.sp, a, offset, length);
        }

        public void push(short v) {
            int idx = this.getPushIndex(1);
            this.data[idx] = v;
        }

        public void push(short[] a, int offset, int length) {
            int idx = this.getPushIndex(length);
            System.arraycopy(a, offset, this.data, idx, length);
        }
    }

    public static class I8
    extends PrimStack {
        private byte[] data = new byte[0];

        @Override
        void resize(int size) {
            byte[] nv = new byte[size];
            System.arraycopy(this.data, 0, nv, 0, Math.min(this.data.length, size));
            this.data = nv;
            this.size = size;
        }

        public byte pop() {
            return this.data[--this.sp];
        }

        public void pop(byte[] a, int offset, int length) {
            this.sp -= length;
            System.arraycopy(this.data, this.sp, a, offset, length);
        }

        public void push(byte v) {
            int idx = this.getPushIndex(1);
            this.data[idx] = v;
        }

        public void push(byte[] a, int offset, int length) {
            int idx = this.getPushIndex(length);
            System.arraycopy(a, offset, this.data, idx, length);
        }
    }
}

