/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

import org.eclipse.jdt.annotation.NonNull;

public abstract class ObjectPool<T> {
    private Object[] values = new Object[0];
    private int firstFree = 0;
    private int inUse = 0;
    private int maxInUse = 0;
    private final int expandChunkSize;

    public ObjectPool(int expandChunkSize) {
        this.expandChunkSize = expandChunkSize;
    }

    public final int getCapacity() {
        return this.values.length;
    }

    public final synchronized int getAndResetMaxInUse() {
        int miu = this.maxInUse;
        this.maxInUse = this.inUse;
        return miu;
    }

    public final synchronized void setCapacity(int newCap) {
        if (newCap == this.values.length) {
            return;
        }
        Object[] oldValues = this.values;
        this.values = new Object[newCap];
        this.firstFree = 0;
        for (Object o : oldValues) {
            if (o == null || this.firstFree == this.values.length) continue;
            this.values[this.firstFree++] = o;
        }
    }

    private synchronized void putIntoList(@NonNull T object) {
        --this.inUse;
        if (this.firstFree == this.values.length) {
            this.setCapacity(this.values.length + this.expandChunkSize);
            if (this.firstFree == this.values.length) {
                return;
            }
        }
        this.values[this.firstFree++] = object;
    }

    @NonNull
    protected abstract T gen();

    public abstract void reset(@NonNull T var1);

    public final synchronized T get() {
        ++this.inUse;
        if (this.inUse > this.maxInUse) {
            this.maxInUse = this.inUse;
        }
        if (this.firstFree > 0) {
            --this.firstFree;
            Object obj = this.values[this.firstFree];
            this.values[this.firstFree] = null;
            return (T)obj;
        }
        return this.gen();
    }

    public final void finish(@NonNull T object) {
        assert (object != null);
        this.reset(object);
        this.putIntoList(object);
    }
}

