/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

public final class MathsX {
    public static final double PI2 = Math.PI * 2;

    public static float fract(float val) {
        return (float)((double)val - Math.floor(val));
    }

    public static float lerpUnclamped(float from, float to, float mix) {
        return from + (to - from) * mix;
    }

    public static float linearSample1d(float frame, float[] buffer, boolean loop) {
        int frame1 = (int)Math.floor(frame);
        float frac = frame - (float)frame1;
        int frame2 = frame1 + 1;
        if (loop) {
            frame1 = MathsX.seqModulo(frame1, buffer.length);
            frame2 = MathsX.seqModulo(frame2, buffer.length);
        } else {
            frame1 = MathsX.clamp(frame1, 0, buffer.length - 1);
            frame2 = MathsX.clamp(frame2, 0, buffer.length - 1);
        }
        return MathsX.lerpUnclamped(buffer[frame1], buffer[frame2], frac);
    }

    public static int clamp(int val, int min, int max) {
        return Math.min(Math.max(val, min), max);
    }

    public static long clamp(long val, long min, long max) {
        return Math.min(Math.max(val, min), max);
    }

    public static float clamp(float val, float min, float max) {
        return Math.min(Math.max(val, min), max);
    }

    public static double clamp(double val, double min, double max) {
        return Math.min(Math.max(val, min), max);
    }

    public static int seqModulo(int x, int length) {
        int base = x % length;
        if (x < 0 && (base += length) >= length) {
            base -= length;
        }
        return base;
    }

    public static long seqModulo(long x, long length) {
        long base = x % length;
        if (x < 0L && (base += length) >= length) {
            base -= length;
        }
        return base;
    }

    public static float seqModulo(float x, float length) {
        float base = x % length;
        if (x < 0.0f && (base += length) >= length) {
            base -= length;
        }
        return base;
    }

    public static double seqModulo(double x, double length) {
        double base = x % length;
        if (x < 0.0 && (base += length) >= length) {
            base -= length;
        }
        return base;
    }
}

