/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.append;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ArrayIterable<T>
implements Iterable<T> {
    private final T[] source;

    public ArrayIterable(T[] array) {
        this.source = array;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<T>(this.source);
    }

    public static final class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] source;
        private int index = 0;

        public ArrayIterator(T[] src) {
            this.source = src;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.source.length;
        }

        @Override
        public T next() {
            if (this.index >= this.source.length) {
                throw new NoSuchElementException("Read off of end of ArrayIterable");
            }
            return this.source[this.index++];
        }
    }
}

