/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.theming;

import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.render.ITexRegion;
import gabien.ui.theming.EightPatch;
import gabien.ui.theming.IBorder;
import gabien.ui.theming.StretchBorder;
import gabien.uslx.append.Rect;

public class TiledBorder
implements IBorder {
    private final EightPatch w3;
    private final IImage tile;
    private final int flags;

    public TiledBorder(int flags, ITexRegion themesImg) {
        this.flags = flags;
        Rect outerRegion = new Rect(6, 0, 6, 6);
        Rect innerRegion = new Rect(3, 3, 0, 0);
        this.w3 = new EightPatch(themesImg, outerRegion, innerRegion);
        this.tile = themesImg.copy(0.0f, 6.0f, 12, 12);
    }

    @Override
    public void draw(IGrDriver igd, int borderWidth, int x, int y, int w, int h) {
        igd.blitTiledImage(x, y, w, h, this.tile);
        if (borderWidth != 0) {
            borderWidth = StretchBorder.ensureBWV(Math.max(borderWidth, 3), 3);
        }
        if (borderWidth <= 0) {
            return;
        }
        this.w3.draw(igd, borderWidth, borderWidth, borderWidth, borderWidth, x, y, w, h);
    }

    @Override
    public boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }
}

