/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.theming;

import datum.DatumReaderTokenSource;
import datum.DatumSrcLoc;
import datum.DatumVisitor;
import gabien.GaBIEn;
import gabien.backend.IGaBIEn;
import gabien.datum.DatumKVDVisitor;
import gabien.ui.theming.Theme;
import gabien.ui.theming.ThemingResCtx;
import java.io.InputStreamReader;
import java.util.LinkedList;

public class ThemingCentral {
    public static final int BF_MOVEDOWN = 1;
    public static final int BF_LIGHTBKG = 8;
    public static Theme[] themes;

    public static void setupAssets(IGaBIEn backend) {
        GaBIEn.verify(backend);
        themes = new Theme[]{Theme.ROOT};
        try {
            Theme tx;
            String[] files;
            final ThemingResCtx resCtx = new ThemingResCtx();
            for (String file : files = new String[]{"themes.gabien.init.scm", "themes.gabien.init.aux.scm", "themes.app.pre.scm", "themes.app.pre.aux.scm", "themes.gabien.scm", "themes.gabien.aux.scm", "themes.app.post.scm", "themes.app.post.aux.scm"}) {
                try {
                    InputStreamReader themesISR = GaBIEn.getTextResource(file);
                    if (themesISR == null) continue;
                    new DatumReaderTokenSource(file, themesISR).visit(new DatumKVDVisitor(){

                        @Override
                        public DatumVisitor handle(String key, DatumSrcLoc loc) {
                            return resCtx.genVisitor(resCtx, key);
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            LinkedList<Theme> themesList = new LinkedList<Theme>();
            int i = 0;
            while ((tx = (Theme)resCtx.resources.get("t" + i)) != null) {
                themesList.add(tx);
                ++i;
            }
            if (i > 0) {
                themes = themesList.toArray(new Theme[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

