/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.theming;

import datum.DatumSrcLoc;
import datum.DatumTreeUtils;
import datum.DatumVisitor;
import gabien.datum.DatumKVDVisitor;
import gabien.datum.DatumODec1Visitor;
import gabien.datum.DatumSeqVisitor;
import gabien.render.ITexRegion;
import gabien.ui.FontManager;
import gabien.ui.LAFChain;
import gabien.ui.theming.DefaultArrowIcon;
import gabien.ui.theming.FallbackBorder;
import gabien.ui.theming.IBorder;
import gabien.ui.theming.IIcon;
import gabien.ui.theming.StretchBorder;
import gabien.ui.theming.ThemingResCtx;
import gabien.ui.theming.TiledBorder;
import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Theme {
    public static final Attr<IBorder> B_BTN = new BAttr("btn", 0);
    public static final Attr<IBorder> B_BTNP = new BAttr("btnP", 1);
    public static final Attr<IBorder> B_LABEL = new BAttr("label", 2);
    public static final Attr<IBorder> B_TEXTBOX = new BAttr("textBox", 3);
    public static final Attr<IBorder> B_TEXTBOXF = new BAttr("textBoxF", 4);
    public static final Attr<IBorder> B_WINDOW = new BAttr("window", 5);
    public static final Attr<IBorder> B_SBTRAY = new BAttr("sbTray", 6);
    public static final Attr<IBorder> B_SBNUB = new BAttr("sbNub", 7);
    public static final Attr<IBorder> B_TABA = new BAttr("tabA", 8);
    public static final Attr<IBorder> B_TABB = new BAttr("tabB", 9);
    public static final Attr<IBorder> B_TABSEL = new BAttr("tabSel", 10);
    public static final Attr<IBorder> B_TITLE = new BAttr("title", 11);
    public static final Attr<IBorder> B_TITLESEL = new BAttr("titleSel", 12);
    public static final Attr<IBorder> B_MENUBORDER = new BAttr("menuBorder", 13);
    public static final Attr<FontManager> FM_GLOBAL = new BuiltinAttr<FontManager>("fontManager", 14, FontManager.class, new FontManager(null, false));
    public static final Attr<IIcon> IC_ARROW_UP = new IAttr("arrowUp", 15, DefaultArrowIcon.DARK_U);
    public static final Attr<IIcon> IC_ARROW_RIGHT = new IAttr("arrowRight", 16, DefaultArrowIcon.DARK_R);
    public static final Attr<IIcon> IC_ARROW_DOWN = new IAttr("arrowDown", 17, DefaultArrowIcon.DARK_D);
    public static final Attr<IIcon> IC_ARROW_LEFT = new IAttr("arrowLeft", 18, DefaultArrowIcon.DARK_L);
    public static final Attr<IBorder> B_NOTABPANEL = new BAttr("noTabPanel", 19);
    private static final Attr<?>[] allBI = new Attr[]{B_BTN, B_BTNP, B_LABEL, B_TEXTBOX, B_TEXTBOXF, B_WINDOW, B_SBTRAY, B_SBNUB, B_TABA, B_TABB, B_TABSEL, B_TITLE, B_TITLESEL, B_MENUBORDER, FM_GLOBAL, IC_ARROW_UP, IC_ARROW_RIGHT, IC_ARROW_DOWN, IC_ARROW_LEFT, B_NOTABPANEL};
    public static final Theme ROOT = new Theme();
    private final HashMap<String, Object> values = new HashMap();
    private final Object[] builtins = new Object[allBI.length];
    static final DatumODec1Visitor.Handler<ThemingResCtx> handler = (k, parent, resCtx) -> new DatumKVDVisitor((ThemingResCtx)resCtx, parent){
        Theme theme = new Theme(ROOT);
        final /* synthetic */ ThemingResCtx val$resCtx;
        final /* synthetic */ DatumODec1Visitor val$parent;
        {
            this.val$resCtx = themingResCtx;
            this.val$parent = datumODec1Visitor;
        }

        @Override
        public DatumVisitor handle(String key, DatumSrcLoc loc) {
            if (key.equals("parent")) {
                return this.val$resCtx.genVisitor((obj, ctx, srcLoc) -> {
                    this.theme = new Theme((Theme)obj);
                }, null);
            }
            return this.val$resCtx.genVisitor((obj, ctx, srcLoc) -> this.theme.set(key, obj), null);
        }

        @Override
        public void visitEnd(DatumSrcLoc srcLoc) {
            this.val$parent.returnVal(this.theme, srcLoc);
        }
    };
    static final DatumODec1Visitor.Handler<ThemingResCtx> brHandler = (k, parent, resCtx) -> Theme.makeGenericBorderVisitor(parent, resCtx);

    private Theme() {
    }

    private Theme(Theme other) {
        System.arraycopy(other.builtins, 0, this.builtins, 0, this.builtins.length);
        this.values.putAll(other.values);
    }

    @Nullable
    public Object getObject(String id) {
        return this.values.get(id);
    }

    private void set(String key, Object obj) {
        for (Attr<?> s : allBI) {
            if (!s.id.equals(key)) continue;
            Attr<?> target = s;
            target.set(this, obj);
            return;
        }
        this.values.put(key, obj);
    }

    public Theme with(String id, @Nullable Object replacement) {
        Theme modified = new Theme(this);
        modified.set(id, replacement);
        return modified;
    }

    private static DatumVisitor makeGenericBorderVisitor(final DatumODec1Visitor<ThemingResCtx, ?> parent, final ThemingResCtx resCtx) {
        return new DatumSeqVisitor(){
            ITexRegion basis;
            int flags = 0;
            boolean tiled = false;

            @Override
            public DatumVisitor handle(int idx) {
                if (idx == 0) {
                    return resCtx.genVisitor((obj, ctx, srcLoc) -> {
                        this.basis = (ITexRegion)obj;
                    }, null);
                }
                return DatumTreeUtils.decVisitor((res, srcLoc) -> {
                    if (DatumTreeUtils.isSym(res, "moveDown")) {
                        this.flags |= 1;
                        return;
                    }
                    if (DatumTreeUtils.isSym(res, "lightBkg")) {
                        this.flags |= 8;
                        return;
                    }
                    if (DatumTreeUtils.isSym(res, "tiled")) {
                        this.tiled = true;
                        return;
                    }
                    throw new RuntimeException("Unrecognized border flag " + res + " @ " + srcLoc);
                });
            }

            @Override
            public void visitEnd(DatumSrcLoc srcLoc) {
                if (this.basis == null) {
                    throw new RuntimeException("Border missing base image @ " + srcLoc);
                }
                IBorder b = this.tiled ? new TiledBorder(this.flags, this.basis) : new StretchBorder(this.flags, this.basis);
                parent.returnVal(b, srcLoc);
            }
        };
    }

    private static class IAttr
    extends BuiltinAttr<IIcon> {
        public IAttr(String id, int iid, IIcon d) {
            super(id, iid, IIcon.class, d);
        }
    }

    private static class BAttr
    extends BuiltinAttr<IBorder> {
        public BAttr(String id, int iid) {
            super(id, iid, IBorder.class, FallbackBorder.INSTANCE);
        }
    }

    private static class BuiltinAttr<T>
    extends Attr<T> {
        final int iid;

        public BuiltinAttr(String id, int iid, Class<T> clz, T def) {
            super(id, clz, def);
            this.iid = iid;
        }

        @Override
        public T get(Theme theme) {
            Object tmp = theme.builtins[this.iid];
            if (tmp == null) {
                return (T)this.def;
            }
            if (!this.clazz.isAssignableFrom(tmp.getClass())) {
                return (T)this.def;
            }
            return (T)tmp;
        }

        @Override
        void set(Theme theme, T res) {
            super.set(theme, res);
            ((Theme)theme).builtins[this.iid] = res;
        }
    }

    public static class Attr<T> {
        public final Class<T> clazz;
        @NonNull
        public final T def;
        public final String id;

        public Attr(String i, Class<T> clz, T def) {
            this.id = i;
            this.clazz = clz;
            this.def = def;
        }

        public T get(Theme theme) {
            Object tmp = theme.getObject(this.id);
            if (tmp == null) {
                return this.def;
            }
            if (!this.clazz.isAssignableFrom(tmp.getClass())) {
                return this.def;
            }
            return (T)tmp;
        }

        public T get(LAFChain src) {
            return this.get(src.getTheme());
        }

        public final Theme with(Theme base, T res) {
            return base.with(this.id, res);
        }

        void set(Theme theme, T res) {
            theme.values.put(this.id, res);
        }
    }
}

