/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.theming;

import gabien.render.IGrDriver;
import gabien.render.ITexRegion;
import gabien.ui.theming.EightPatch;
import gabien.ui.theming.IBorder;
import gabien.uslx.append.Rect;

public class StretchBorder
implements IBorder {
    private final EightPatch w1;
    private final EightPatch w2;
    private final EightPatch w4;
    private final ITexRegion stretchC1;
    private final ITexRegion stretchC2;
    private final ITexRegion stretchC4;
    private final int flags;

    public StretchBorder(int flags, ITexRegion themesImg) {
        Rect outerRegion = new Rect(0, 0, 3, 3);
        Rect innerRegion = new Rect(1, 1, 1, 1);
        this.w1 = new EightPatch(themesImg, outerRegion, innerRegion);
        outerRegion = new Rect(6, 0, 6, 6);
        innerRegion = new Rect(2, 2, 2, 2);
        this.w2 = new EightPatch(themesImg, outerRegion, innerRegion);
        outerRegion = new Rect(0, 6, 12, 12);
        innerRegion = new Rect(4, 4, 4, 4);
        this.w4 = new EightPatch(themesImg, outerRegion, innerRegion);
        this.stretchC1 = themesImg.subRegion(1.0f, 1.0f, 1.0f, 1.0f);
        this.stretchC2 = themesImg.subRegion(8.0f, 2.0f, 2.0f, 2.0f);
        this.stretchC4 = themesImg.subRegion(4.0f, 10.0f, 4.0f, 4.0f);
        this.flags = flags;
    }

    @Override
    public void draw(IGrDriver igd, int borderWidth, int x, int y, int w, int h) {
        int eBorderWidth = borderWidth;
        if (borderWidth == 0) {
            eBorderWidth = Math.min(w, h);
        }
        int chunkSize = 1;
        ITexRegion stretchRegion = this.stretchC1;
        if (eBorderWidth >= 2) {
            chunkSize = 2;
            stretchRegion = this.stretchC2;
        }
        if (eBorderWidth >= 4) {
            chunkSize = 4;
            stretchRegion = this.stretchC4;
        }
        borderWidth = StretchBorder.ensureBWV(borderWidth, chunkSize);
        igd.blitScaledImage(x + borderWidth, y + borderWidth, w - borderWidth * 2, h - borderWidth * 2, stretchRegion);
        if (borderWidth <= 0) {
            return;
        }
        EightPatch borderAsset = chunkSize == 1 ? this.w1 : (chunkSize == 2 ? this.w2 : this.w4);
        borderAsset.draw(igd, borderWidth, borderWidth, borderWidth, borderWidth, x, y, w, h);
    }

    @Override
    public boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public static int ensureBWV(int borderWidth, int chunk) {
        if (borderWidth > chunk) {
            return (borderWidth + 2) / chunk * chunk;
        }
        return borderWidth;
    }
}

