/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.theming;

import gabien.render.IGrDriver;
import gabien.render.ITexRegion;
import gabien.uslx.append.Rect;

public final class EightPatch {
    public final Rect outerRegion;
    public final Rect innerRegion;
    public final ITexRegion region0;
    public final ITexRegion region1;
    public final ITexRegion region2;
    public final ITexRegion region3;
    public final ITexRegion region5;
    public final ITexRegion region6;
    public final ITexRegion region7;
    public final ITexRegion region8;
    public final int w0;
    public final int h0;
    public final int w2;
    public final int h2;

    public EightPatch(ITexRegion image, Rect or, Rect ir) {
        this.outerRegion = or;
        this.innerRegion = ir;
        boolean emptyW = ir.width == 0;
        boolean emptyH = ir.height == 0;
        int nudgeX1 = emptyW ? -1 : 0;
        int nudgeY1 = emptyH ? -1 : 0;
        int x0 = this.outerRegion.x;
        int x1 = x0 + this.innerRegion.x + nudgeX1;
        int x2 = x1 + this.innerRegion.width - nudgeX1;
        int y0 = this.outerRegion.y;
        int y1 = y0 + this.innerRegion.y + nudgeY1;
        int y2 = y1 + this.innerRegion.height - nudgeY1;
        this.w0 = this.innerRegion.x;
        int w1 = emptyW ? 2 : this.innerRegion.width;
        this.w2 = this.outerRegion.width - (this.innerRegion.x + this.innerRegion.width);
        this.h0 = this.innerRegion.y;
        int h1 = emptyH ? 2 : this.innerRegion.height;
        this.h2 = this.outerRegion.height - (this.innerRegion.y + this.innerRegion.height);
        this.region0 = image.subRegion(x0, y0, this.w0, this.h0);
        this.region1 = image.subRegion(x1, y0, w1, this.h0);
        this.region2 = image.subRegion(x2, y0, this.w2, this.h0);
        this.region3 = image.subRegion(x0, y1, this.w0, h1);
        this.region5 = image.subRegion(x2, y1, this.w2, h1);
        this.region6 = image.subRegion(x0, y2, this.w0, this.h2);
        this.region7 = image.subRegion(x1, y2, w1, this.h2);
        this.region8 = image.subRegion(x2, y2, this.w2, this.h2);
    }

    public final void draw(IGrDriver igd, int bs, int tx0, int ty0, int w, int h) {
        int tw0 = this.w0 * bs;
        int tw2 = this.w2 * bs;
        int th0 = this.h0 * bs;
        int th2 = this.h2 * bs;
        this.draw(igd, tw0, tw2, th0, th2, tx0, ty0, w, h);
    }

    public final void draw(IGrDriver igd, int tw0, int tw2, int th0, int th2, int tx0, int ty0, int w, int h) {
        int tw1 = w - (tw0 + tw2);
        int th1 = h - (th0 + th2);
        int tx1 = tx0 + tw0;
        int tx2 = tx0 + w - tw2;
        int ty1 = ty0 + th0;
        int ty2 = ty0 + h - th2;
        igd.blitScaledImage(tx0, ty0, tw0, th0, this.region0);
        igd.blitScaledImage(tx1, ty0, tw1, th0, this.region1);
        igd.blitScaledImage(tx2, ty0, tw2, th0, this.region2);
        igd.blitScaledImage(tx0, ty1, tw0, th1, this.region3);
        igd.blitScaledImage(tx2, ty1, tw2, th1, this.region5);
        igd.blitScaledImage(tx0, ty2, tw0, th2, this.region6);
        igd.blitScaledImage(tx1, ty2, tw1, th2, this.region7);
        igd.blitScaledImage(tx2, ty2, tw2, th2, this.region8);
    }
}

