/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.theming;

import gabien.render.IGrDriver;
import gabien.ui.theming.IIcon;

public class DefaultArrowIcon
implements IIcon {
    private static final int PSC = 8;
    private int[] points = new int[]{4, 2, 6, 6, 2, 6};
    private final float r;
    private final float g;
    private final float b;
    private final float a;
    public static final DefaultArrowIcon DARK_U = new DefaultArrowIcon(0, 1.0f, 1.0f, 1.0f, 1.0f);
    public static final DefaultArrowIcon DARK_R = new DefaultArrowIcon(1, 1.0f, 1.0f, 1.0f, 1.0f);
    public static final DefaultArrowIcon DARK_D = new DefaultArrowIcon(2, 1.0f, 1.0f, 1.0f, 1.0f);
    public static final DefaultArrowIcon DARK_L = new DefaultArrowIcon(3, 1.0f, 1.0f, 1.0f, 1.0f);

    public DefaultArrowIcon(int rotation, float r, float g, float b, float a) {
        for (int i = 0; i < rotation; ++i) {
            for (int j = 0; j < 6; j += 2) {
                int oX = this.points[j];
                int oY = this.points[j + 1];
                this.points[j] = 8 - oY;
                this.points[j + 1] = oX;
            }
        }
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    @Override
    public void draw(IGrDriver igd, int x, int y, int size) {
        float aX = (float)(this.points[0] * size) / 8.0f + (float)x;
        float aY = (float)(this.points[1] * size) / 8.0f + (float)y;
        float bX = (float)(this.points[2] * size) / 8.0f + (float)x;
        float bY = (float)(this.points[3] * size) / 8.0f + (float)y;
        float cX = (float)(this.points[4] * size) / 8.0f + (float)x;
        float cY = (float)(this.points[5] * size) / 8.0f + (float)y;
        igd.drawXYSTRGBA(IGrDriver.BLEND_NORMAL, 0, null, aX, aY, 0.0f, 0.0f, this.r, this.g, this.b, this.a, bX, bY, 0.0f, 0.0f, this.r, this.g, this.b, this.a, cX, cY, 0.0f, 0.0f, this.r, this.g, this.b, this.a);
    }
}

