/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.layouts;

import datum.DatumSrcLoc;
import datum.DatumWriter;
import gabien.GaBIEnUI;
import gabien.render.IGrDriver;
import gabien.ui.FontManager;
import gabien.ui.IPointerReceiver;
import gabien.ui.UIElement;
import gabien.ui.UILayer;
import gabien.ui.elements.UIBorderedElement;
import gabien.ui.layouts.UITabBar;
import gabien.ui.theming.Theme;
import gabien.uslx.append.Block;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import java.util.LinkedList;
import java.util.Random;
import java.util.function.Consumer;

public class UIWindowView
extends UIElement {
    private final LinkedList<IShell> desktop = new LinkedList();
    public IShell selectedWindow;
    private IShell[] desktopCache = new IShell[0];
    private boolean desktopChanged = false;
    private boolean clearKeysLater = false;
    public int windowTextHeight = 12;
    public int sizerVisual = 3;
    public int sizerActual = 8;

    public int getWindowFrameHeight() {
        return UITabBar.getHeight(this.windowTextHeight);
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        if (this.clearKeysLater) {
            peripherals.clearKeys();
            this.clearKeysLater = false;
        }
        this.updateDesktopCache();
        for (IShell shl : this.desktopCache) {
            shl.update(deltaTime, selected, peripherals);
        }
    }

    @Override
    public void renderLayer(IGrDriver igd, UILayer layer) {
        if (layer != UILayer.Content) {
            return;
        }
        this.updateDesktopCache();
        for (IShell shl : this.desktopCache) {
            shl.render(igd);
        }
    }

    private void updateDesktopCache() {
        if (this.desktopChanged) {
            this.desktopCache = this.desktop.toArray(new IShell[0]);
            this.desktopChanged = false;
        }
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer state) {
        this.updateDesktopCache();
        IShell[] array = this.desktopCache;
        for (int i = array.length - 1; i >= 0; --i) {
            IPointerReceiver ipr = array[i].provideReceiver(state);
            if (ipr == null) continue;
            return ipr;
        }
        return null;
    }

    @Override
    public void handleMousewheel(int x, int y, boolean north) {
        this.updateDesktopCache();
        IShell[] array = this.desktopCache;
        for (int i = array.length - 1; i >= 0; --i) {
            if (!array[i].handleMousewheel(x, y, north)) continue;
            return;
        }
    }

    public void addShell(IShell t) {
        t.setAttachedToRoot(this.getAttachedToRoot());
        this.desktop.add(t);
        this.desktopChanged = true;
    }

    public void removeShell(IShell t) {
        this.removeShell(t, RemoveReason.Manual);
    }

    public void removeShell(IShell t, RemoveReason selfDestruct) {
        this.desktop.remove(t);
        this.desktopChanged = true;
        t.setAttachedToRoot(false);
        t.removed(selfDestruct);
    }

    public void raiseShell(IShell t) {
        this.selectedWindow = t;
        this.desktop.remove(t);
        this.desktop.add(t);
        this.desktopChanged = true;
    }

    public void lowerShell(IShell t) {
        this.desktop.remove(t);
        this.desktop.addFirst(t);
        this.desktopChanged = true;
    }

    public void removeTab(UITabBar.Tab win) {
        this.removeTab(win, RemoveReason.Manual);
    }

    public void removeTab(UITabBar.Tab win, RemoveReason selfDestruct) {
        this.updateDesktopCache();
        for (IShell s : this.desktopCache) {
            if (s != win) continue;
            this.removeShell(s, selfDestruct);
            return;
        }
    }

    public void cleanup() {
        this.updateDesktopCache();
        for (IShell s : this.desktopCache) {
            this.removeShell(s, RemoveReason.Cleanup);
        }
        this.updateDesktopCache();
    }

    @Override
    public void onWindowClose() {
        this.cleanup();
    }

    public LinkedList<IShell> getShells() {
        return new LinkedList<IShell>(this.desktop);
    }

    @Override
    public void setAttachedToRoot(boolean attached) {
        super.setAttachedToRoot(attached);
        this.updateDesktopCache();
        for (IShell s : this.desktopCache) {
            s.setAttachedToRoot(attached);
        }
    }

    @Override
    public void debugDumpUITree(DatumWriter writer) {
        super.debugDumpUITree(writer);
        for (IShell s : this.desktopCache) {
            writer.visitList(DatumSrcLoc.NONE);
            ++writer.indent;
            s.debugDumpUITree(writer);
            --writer.indent;
            writer.visitEnd(DatumSrcLoc.NONE);
            writer.visitNewline();
        }
    }

    public static final class MenuShell
    extends ElementShell {
        private final UIElement baseElem;
        private final Rect base;

        public MenuShell(UIWindowView parent, UIElement menu, UIElement baseElem, Rect base) {
            super(parent, menu);
            this.baseElem = baseElem;
            this.base = base;
        }

        @Override
        public IPointerReceiver provideReceiver(IPointer i) {
            IPointerReceiver ipr = super.provideReceiver(i);
            if (ipr == null) {
                this.parent.removeShell(this);
                this.uie.onWindowClose();
                return IPointerReceiver.NopPointerReceiver.I;
            }
            return ipr;
        }

        @Override
        public void render(IGrDriver igd) {
            Size sz = this.parent.getSize();
            igd.fillRect(0, 0, 0, 128, 0.0f, 0.0f, sz.width, sz.height);
            int bw = 4;
            Rect r = this.uie.getParentRelativeBounds();
            Theme theme = GaBIEnUI.sysThemeRoot.getTheme();
            UIBorderedElement.drawBorder(theme, igd, Theme.B_MENUBORDER, bw, r.x - bw, r.y - bw, r.width + bw * 2, r.height + bw * 2);
            try (Block b = igd.openTranslate(this.base.x, this.base.y);){
                this.baseElem.renderAllLayers(igd);
            }
            super.render(igd);
        }
    }

    public static class ScreenShell
    extends ElementShell {
        public ScreenShell(UIWindowView parent, UIElement element) {
            super(parent, element);
            this.uie.setForcedBounds(null, new Rect(parent.getSize()));
        }

        private void updateSize() {
            Size gs = this.parent.getSize();
            if (!gs.sizeEquals(this.uie.getSize())) {
                this.uie.setForcedBounds(null, new Rect(gs));
            }
        }

        @Override
        public void render(IGrDriver igd) {
            this.updateSize();
            super.render(igd);
        }

        @Override
        public void update(double deltaTime, boolean parentSelected, IPeripherals peripherals) {
            this.updateSize();
            super.update(deltaTime, parentSelected, peripherals);
        }
    }

    public static class ElementShell
    implements IShell {
        public final UIWindowView parent;
        public final UIElement uie;

        public ElementShell(UIWindowView parent, UIElement element) {
            this.parent = parent;
            this.uie = element;
        }

        @Override
        public IPointerReceiver provideReceiver(IPointer i) {
            Rect bounds = this.uie.getParentRelativeBounds();
            if (!bounds.contains(i.getX(), i.getY())) {
                return null;
            }
            i.performOffset(-bounds.x, -bounds.y);
            IPointerReceiver ipr = this.uie.handleNewPointer(i);
            i.performOffset(bounds.x, bounds.y);
            if (ipr == null) {
                return null;
            }
            this.parent.selectedWindow = this;
            return new IPointerReceiver.TransformingElementPointerReceiver(this.uie, ipr);
        }

        @Override
        public boolean handleMousewheel(int x, int y, boolean north) {
            Rect r = this.uie.getParentRelativeBounds();
            if (r.contains(x, y)) {
                this.parent.selectedWindow = this;
                this.uie.handleMousewheel(x - r.x, y - r.y, north);
                return true;
            }
            return false;
        }

        @Override
        public void render(IGrDriver igd) {
            for (UILayer layer : UIElement.LAYERS) {
                UIElement.UIPanel.scissoredRender(this.uie, igd, layer);
            }
        }

        @Override
        public void update(double deltaTime, boolean parentSelected, IPeripherals peripherals) {
            boolean requestedUnparenting = this.uie.requestsUnparenting();
            if (requestedUnparenting) {
                this.parent.removeShell(this, RemoveReason.RequestedUnparent);
            } else {
                Rect r = this.uie.getParentRelativeBounds();
                peripherals.performOffset(-r.x, -r.y);
                this.uie.update(deltaTime, this.parent.selectedWindow == this && parentSelected, peripherals);
                peripherals.performOffset(r.x, r.y);
            }
        }

        @Override
        public void removed(RemoveReason reason) {
            if (reason != RemoveReason.Manual) {
                this.uie.onWindowClose();
            }
        }

        @Override
        public void setAttachedToRoot(boolean attached) {
            this.uie.setAttachedToRoot(attached);
        }

        @Override
        public void debugDumpUITree(DatumWriter writer) {
            this.uie.debugDumpUITree(writer);
        }
    }

    public static class TabShell
    extends UITabBar.Tab
    implements IShell {
        public final UIWindowView parent;
        public boolean removed = false;

        public TabShell(UIWindowView p, UIElement contents, UITabBar.TabIcon[] icons) {
            super(contents, icons);
            this.parent = p;
            this.finishInit();
        }

        private void finishInit() {
            Rect r = this.contents.getParentRelativeBounds();
            Size g = this.parent.getSize();
            int areaX = g.width - r.width;
            if (areaX < 0) {
                areaX = 0;
            }
            int cX = new Random().nextInt(areaX + 1);
            int tabShellNewAreaForgiveness = this.parent.windowTextHeight * 6;
            if (g.height - tabShellNewAreaForgiveness < r.height) {
                this.contents.setForcedBounds(null, new Rect(cX, 0, r.width, g.height - this.parent.getWindowFrameHeight()));
            } else {
                this.contents.setForcedBounds(null, new Rect(cX, tabShellNewAreaForgiveness, r.width, r.height));
            }
            this.windowBoundsCheck();
        }

        @Override
        public IPointerReceiver provideReceiver(IPointer i) {
            int y;
            final Rect r = this.contents.getParentRelativeBounds();
            int fh = this.parent.getWindowFrameHeight();
            Rect mainframe = new Rect(r.x - this.parent.sizerActual, r.y - (this.parent.sizerActual + fh), r.width + this.parent.sizerActual * 2, r.height + this.parent.sizerActual * 2 + fh);
            Rect framebar = new Rect(r.x, r.y - fh, r.width, fh);
            int x = i.getX();
            if (framebar.contains(x, y = i.getY())) {
                this.parent.selectedWindow = this;
                this.parent.raiseShell(this);
                if (!UITabBar.clickInTab(this, x - framebar.x, y - framebar.y, framebar.width, fh)) {
                    return new IPointerReceiver.RelativeResizePointerReceiver(r.x, r.y, new Consumer<Size>(){

                        @Override
                        public void accept(Size size) {
                            Size cs = contents.getSize();
                            if (!removed) {
                                contents.setForcedBounds(null, new Rect(size.width, size.height, cs.width, cs.height));
                            }
                            this.windowBoundsCheck();
                        }
                    });
                }
                return IPointerReceiver.NopPointerReceiver.I;
            }
            if (r.contains(x, y)) {
                this.parent.selectedWindow = this;
                this.parent.raiseShell(this);
                i.performOffset(-r.x, -r.y);
                IPointerReceiver ipr = this.contents.handleNewPointer(i);
                i.performOffset(r.x, r.y);
                if (ipr != null) {
                    return new IPointerReceiver.TransformingElementPointerReceiver(this.contents, ipr);
                }
                return IPointerReceiver.NopPointerReceiver.I;
            }
            if (mainframe.contains(x, y)) {
                this.parent.selectedWindow = this;
                this.parent.raiseShell(this);
                int tx = x - mainframe.x;
                int ty = y - mainframe.y;
                int third = Math.max(this.parent.sizerActual, Math.min(mainframe.width / 3, mainframe.height / 3));
                int ttx = 0;
                int tty = 0;
                int rw = 0;
                int rh = 0;
                if (tx < third) {
                    ttx = -1;
                    rw = r.x;
                } else if (tx >= mainframe.width - third) {
                    ttx = 1;
                    rw = r.width;
                }
                if (ty < third) {
                    tty = -1;
                    rh = r.y;
                } else if (ty >= mainframe.height - third) {
                    tty = 1;
                    rh = r.height;
                }
                final int tfx = ttx;
                final int tfy = tty;
                return new IPointerReceiver.RelativeResizePointerReceiver(rw, rh, new Consumer<Size>(){

                    @Override
                    public void accept(Size size) {
                        Rect basis = contents.getParentRelativeBounds();
                        int resX = basis.x;
                        int resY = basis.y;
                        int resW = basis.width;
                        int resH = basis.height;
                        if (tfx == -1) {
                            resX = size.width;
                            resW = r.x + r.width - size.width;
                        } else if (tfx == 1) {
                            resW = size.width;
                        }
                        if (tfy == -1) {
                            resY = size.height;
                            resH = r.y + r.height - size.height;
                        } else if (tfy == 1) {
                            resH = size.height;
                        }
                        if (!removed) {
                            contents.setForcedBounds(null, new Rect(resX, resY, resW, resH));
                        }
                    }
                });
            }
            return null;
        }

        @Override
        public boolean handleMousewheel(int x, int y, boolean north) {
            Rect r = this.contents.getParentRelativeBounds();
            int fh = this.parent.getWindowFrameHeight();
            Rect visframe = new Rect(r.x - this.parent.sizerVisual, r.y - (this.parent.sizerVisual + fh), r.width + this.parent.sizerVisual * 2, r.height + this.parent.sizerVisual * 2 + fh);
            if (visframe.contains(x, y)) {
                this.parent.selectedWindow = this;
                this.parent.raiseShell(this);
                if (r.contains(x, y)) {
                    this.contents.handleMousewheel(x - r.x, y - r.y, north);
                }
                return true;
            }
            return false;
        }

        @Override
        public void render(IGrDriver igd) {
            int windowFrameHeight = this.parent.getWindowFrameHeight();
            Rect b = this.contents.getParentRelativeBounds();
            Theme theme = this.contents.getTheme();
            UIBorderedElement.drawBorder(theme, igd, Theme.B_WINDOW, this.parent.sizerVisual, b.x - this.parent.sizerVisual, b.y - (windowFrameHeight + this.parent.sizerVisual), b.width + this.parent.sizerVisual * 2, b.height + (windowFrameHeight + this.parent.sizerVisual * 2));
            boolean winSelected = this.parent.selectedWindow == this;
            UITabBar.drawTab(theme, winSelected ? Theme.B_TITLESEL : Theme.B_TITLE, b.x, b.y - windowFrameHeight, b.width, windowFrameHeight, igd, this.contents.toString(), this);
            for (UILayer layer : UIElement.LAYERS) {
                UIElement.UIPanel.scissoredRender(this.contents, igd, layer);
            }
        }

        @Override
        public void update(double deltaTime, boolean parentSelected, IPeripherals peripherals) {
            this.windowBoundsCheck();
            boolean requestedUnparenting = this.contents.requestsUnparenting();
            if (requestedUnparenting) {
                this.parent.removeShell(this, RemoveReason.RequestedUnparent);
            } else {
                Rect r = this.contents.getParentRelativeBounds();
                peripherals.performOffset(-r.x, -r.y);
                this.contents.update(deltaTime, this.parent.selectedWindow == this && parentSelected, peripherals);
                peripherals.performOffset(r.x, r.y);
            }
        }

        @Override
        public void removed(RemoveReason destroy) {
            this.removed = true;
            this.contents.setAttachedToRoot(false);
            if (destroy != RemoveReason.Manual) {
                this.contents.onWindowClose();
            }
        }

        public void windowBoundsCheck() {
            int fh = this.parent.getWindowFrameHeight();
            Size scr = this.parent.getSize();
            Rect s = this.contents.getParentRelativeBounds();
            int ox = s.x;
            int oy = s.y;
            if (ox < 0) {
                ox = 0;
            }
            if (ox > scr.width - s.width) {
                ox = scr.width - s.width;
            }
            if (oy < fh) {
                oy = fh;
            }
            if (oy > scr.height) {
                oy = scr.height;
            }
            int ow = s.width;
            int oh = s.height;
            if (ox < 0) {
                ow += ox;
                ox = 0;
            }
            Theme th = this.contents.getTheme();
            FontManager fm = Theme.FM_GLOBAL.get(this.contents);
            ow = Math.max(ow, UITabBar.getTabWidth(th, fm, this, 0, fh));
            oh = Math.max(oh, 0);
            if (ox != s.x || oy != s.y || ow != s.width || oh != s.height) {
                this.contents.setForcedBounds(null, new Rect(ox, oy, ow, oh));
            }
        }

        @Override
        public void setAttachedToRoot(boolean attached) {
            this.contents.setAttachedToRoot(attached);
        }

        @Override
        public void debugDumpUITree(DatumWriter writer) {
            this.contents.debugDumpUITree(writer);
        }
    }

    public static enum RemoveReason {
        Cleanup,
        RequestedUnparent,
        Manual;

    }

    public static interface IShell {
        public IPointerReceiver provideReceiver(IPointer var1);

        public boolean handleMousewheel(int var1, int var2, boolean var3);

        public void render(IGrDriver var1);

        public void update(double var1, boolean var3, IPeripherals var4);

        public void removed(RemoveReason var1);

        public void setAttachedToRoot(boolean var1);

        public void debugDumpUITree(DatumWriter var1);
    }
}

