/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.layouts;

import gabien.render.IGrDriver;
import gabien.ui.UIElement;
import gabien.ui.UILayer;
import gabien.ui.layouts.UITabBar;
import gabien.ui.theming.Theme;
import gabien.uslx.append.Block;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;
import java.util.LinkedList;
import org.eclipse.jdt.annotation.Nullable;

public class UITabPane
extends UIElement.UIPanel {
    private final UIElement thbrLeft;
    private final UIElement thbrRight;
    private final UITabBar tabManager;
    private int tabOverheadHeight;
    protected UITabBar.Tab selectedTab;

    public UITabPane(int h, boolean csn, boolean cdt) {
        this(h, csn, cdt, 0);
    }

    public UITabPane(int h, boolean csn, boolean cdt, int scrollerSize) {
        this(h, csn, cdt, scrollerSize, null, null);
    }

    public UITabPane(int h, boolean csn, boolean cdt, int scrollerSize, UIElement tl, UIElement tr) {
        this.tabManager = new UITabBar(csn, cdt, this, h, scrollerSize);
        this.layoutAddElement(this.tabManager);
        this.thbrLeft = tl;
        this.thbrRight = tr;
        if (this.thbrLeft != null) {
            this.layoutAddElement(this.thbrLeft);
        }
        if (this.thbrRight != null) {
            this.layoutAddElement(this.thbrRight);
        }
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        super.update(deltaTime, selected, peripherals);
    }

    @Override
    public void renderLayer(IGrDriver igd, UILayer layer) {
        super.renderLayer(igd, layer);
        if (layer != UILayer.Base) {
            return;
        }
        if (this.selectedTab == null) {
            Size bounds = this.getSize();
            try (Block b = igd.openScissor(0.0f, this.tabOverheadHeight, bounds.width, bounds.height - this.tabOverheadHeight);){
                this.renderNoTabPanel(igd, 0, this.tabOverheadHeight, bounds.width, bounds.height - this.tabOverheadHeight);
            }
        }
    }

    public void renderNoTabPanel(IGrDriver igd, int x, int y, int w, int h) {
        Theme.B_NOTABPANEL.get(this).draw(igd, this.tabOverheadHeight / 2, x, y, w, h);
    }

    public void handleClosedUserTab(UITabBar.Tab wvWindow, boolean selfDestruct) {
        if (selfDestruct) {
            wvWindow.contents.onWindowClose();
        }
    }

    public void handleTabReorderComplete() {
    }

    public boolean handleIncoming() {
        return this.tabManager.handleIncoming();
    }

    private int getTMLeftMargin() {
        if (this.thbrLeft != null) {
            return this.thbrLeft.getWantedSize().width;
        }
        return 0;
    }

    private int getTMRightMargin() {
        if (this.thbrRight != null) {
            return this.thbrRight.getWantedSize().width;
        }
        return 0;
    }

    private int getTabOverheadHeightForW(int width) {
        Size thbrLeftWS = Size.ZERO;
        Size thbrRightWS = Size.ZERO;
        if (this.thbrLeft != null) {
            thbrLeftWS = this.thbrLeft.getWantedSize();
        }
        if (this.thbrRight != null) {
            thbrRightWS = this.thbrRight.getWantedSize();
        }
        int toh = this.tabManager.layoutGetHForW(width - (thbrLeftWS.width + thbrRightWS.width));
        return Math.max(toh, Math.max(thbrLeftWS.height, thbrRightWS.height));
    }

    @Override
    protected void layoutRunImpl() {
        Size r = this.getSize();
        int toh = this.getTabOverheadHeightForW(r.width);
        int tmLeftMargin = this.getTMLeftMargin();
        int tmRightMargin = this.getTMRightMargin();
        this.tabOverheadHeight = toh;
        if (this.thbrLeft != null) {
            this.thbrLeft.setForcedBounds(this, new Rect(0, 0, tmLeftMargin, this.tabOverheadHeight));
        }
        if (this.thbrRight != null) {
            this.thbrRight.setForcedBounds(this, new Rect(r.width - tmRightMargin, 0, tmRightMargin, this.tabOverheadHeight));
        }
        this.tabManager.setForcedBounds(this, new Rect(tmLeftMargin, 0, r.width - (tmLeftMargin + tmRightMargin), this.tabOverheadHeight));
        if (this.selectedTab != null) {
            UIElement uie = this.selectedTab.contents;
            uie.setForcedBounds(this, new Rect(0, this.tabOverheadHeight, r.width, r.height - this.tabOverheadHeight));
        }
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        Size w = this.tabManager.getWantedSize();
        Size uhoh = new Size(0, 0);
        if (this.selectedTab != null) {
            UIElement uie = this.selectedTab.contents;
            uhoh = uie.getWantedSize();
        }
        return new Size(Math.max(w.width + this.getTMLeftMargin() + this.getTMRightMargin(), uhoh.width), w.height + uhoh.height);
    }

    @Override
    public int layoutGetHForW(int width) {
        int toh = this.getTabOverheadHeightForW(width);
        if (this.selectedTab != null) {
            UIElement uie = this.selectedTab.contents;
            return toh + uie.layoutGetHForW(width);
        }
        return toh;
    }

    public void selectTab(UIElement target) {
        if (target == null) {
            if (this.selectedTab != null) {
                this.layoutRemoveElement(this.selectedTab.contents);
                this.selectedTab = null;
            }
            return;
        }
        for (int i = 0; i < 2; ++i) {
            for (UITabBar.Tab wv : this.tabManager.tabs) {
                if (wv.contents != target) continue;
                for (UIElement uie : this.layoutGetElements()) {
                    if (uie == this.tabManager || uie == this.thbrLeft || uie == this.thbrRight) continue;
                    this.layoutRemoveElement(uie);
                }
                this.selectedTab = wv;
                this.layoutAddElement(this.selectedTab.contents);
                this.layoutSelect(this.selectedTab.contents);
                this.layoutRecalculateMetrics();
                return;
            }
            if (!this.handleIncoming()) continue;
            this.layoutRecalculateMetrics();
        }
        throw new RuntimeException("The tab being selected was not available in this pane.");
    }

    public int getTabIndex() {
        int idx = 0;
        for (UITabBar.Tab tab : this.tabManager.tabs) {
            if (this.selectedTab == tab) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public double getScrollPoint() {
        return this.tabManager.getScrollPoint();
    }

    public void setScrollPoint(double point) {
        this.tabManager.setScrollPoint(point);
    }

    public boolean getShortened() {
        return this.tabManager.shortTabs != -1;
    }

    public void addTab(UITabBar.Tab wvWindow) {
        this.tabManager.incomingTabs.add(wvWindow);
    }

    public void removeTab(UITabBar.Tab tab) {
        if (this.selectedTab != null && this.selectedTab.equals(tab)) {
            this.layoutRemoveElement(this.selectedTab.contents);
            this.selectedTab = null;
            this.tabManager.findReplacementTab();
        }
        this.tabManager.outgoingTabs.add(tab);
    }

    public LinkedList<UITabBar.Tab> getTabs() {
        LinkedList<UITabBar.Tab> wv = new LinkedList<UITabBar.Tab>();
        wv.addAll(this.tabManager.tabs);
        wv.addAll(this.tabManager.incomingTabs);
        return wv;
    }

    void tightlyCoupledLayoutRecalculateMetrics() {
        this.layoutRecalculateMetrics();
    }
}

