/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.layouts;

import gabien.render.IGrDriver;
import gabien.text.TextTools;
import gabien.ui.FontManager;
import gabien.ui.IPointerReceiver;
import gabien.ui.UIElement;
import gabien.ui.UILayer;
import gabien.ui.elements.UIBorderedElement;
import gabien.ui.elements.UIScrollbar;
import gabien.ui.layouts.UITabPane;
import gabien.ui.theming.IBorder;
import gabien.ui.theming.IIcon;
import gabien.ui.theming.Theme;
import gabien.uslx.append.Block;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IPointer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

public class UITabBar
extends UIElement.UIPanel {
    public LinkedList<Tab> tabs = new LinkedList();
    public LinkedList<Tab> incomingTabs = new LinkedList();
    public HashSet<Tab> outgoingTabs = new HashSet();
    public final UITabPane parentView;
    private final UIScrollbar tabScroller;
    public final boolean canSelectNone;
    public final boolean canDragTabs;
    protected int shortTabs = -1;
    private final int wantedHeight;
    private int effectiveHeight;
    private int fullWantedHeight;
    private int scrollAreaX;
    private boolean tabReorderDidSomething = false;
    public WeakHashMap<Tab, IPointerReceiver.RelativeResizePointerReceiver> draggingTabs = new WeakHashMap();

    public UITabBar(boolean selectNone, boolean canDrag, UITabPane par, int h, int scrollerSize) {
        this.canSelectNone = selectNone;
        this.canDragTabs = canDrag;
        this.parentView = par;
        this.wantedHeight = UITabBar.getHeight(h);
        this.tabScroller = scrollerSize == 0 ? null : new UIScrollbar(false, scrollerSize);
    }

    @Override
    public void renderLayer(IGrDriver igd, UILayer layer) {
        super.renderLayer(igd, layer);
        Theme theme = this.getTheme();
        if (layer == UILayer.Base) {
            Size bounds = this.getSize();
            UIBorderedElement.drawBorder(theme, igd, Theme.B_TABA, 0, 0, 0, bounds.width, this.effectiveHeight);
        }
        if (layer == UILayer.Content) {
            boolean willUpdateLater = this.parentView.handleIncoming();
            HashSet<Tab> outgoingTabs2 = this.outgoingTabs;
            this.outgoingTabs = new HashSet();
            for (Tab w : this.tabs) {
                boolean reqU = w.contents.requestsUnparenting();
                if (!outgoingTabs2.contains(w) && !reqU) continue;
                willUpdateLater = true;
                outgoingTabs2.add(w);
                this.parentView.handleClosedUserTab(w, reqU);
            }
            if (this.parentView.selectedTab != null && outgoingTabs2.contains(this.parentView.selectedTab)) {
                this.findReplacementTab();
            }
            this.tabs.removeAll(outgoingTabs2);
            if (willUpdateLater) {
                this.parentView.tightlyCoupledLayoutRecalculateMetrics();
            }
        }
        if (layer == UILayer.Base) {
            this.renderTabPass(theme, igd, false, true, false);
        }
        if (layer == UILayer.Content) {
            this.renderTabPass(theme, igd, false, false, true);
            if (this.draggingTabs.size() > 0 && this.canDragTabs) {
                this.renderTabPass(theme, igd, true, true, true);
            }
        }
    }

    private void renderTabPass(Theme theme, IGrDriver igd, boolean isRenderingDraggedTabs, boolean enBack, boolean enFore) {
        int pos = this.getScrollOffsetX();
        boolean toggle = false;
        FontManager fm = Theme.FM_GLOBAL.get(theme);
        for (Tab w : this.tabs) {
            Theme.Attr<IBorder> base;
            int theDisplayOX = pos;
            int tabW = UITabBar.getTabWidth(theme, fm, w, this.shortTabs, this.effectiveHeight);
            Theme.Attr<IBorder> attr = base = toggle ? Theme.B_TABB : Theme.B_TABA;
            if (this.parentView.selectedTab == w) {
                base = Theme.B_TABSEL;
            }
            toggle = !toggle;
            boolean shouldRender = true;
            if (!isRenderingDraggedTabs) {
                if (this.draggingTabs.containsKey(w)) {
                    shouldRender = false;
                }
            } else {
                IPointerReceiver.RelativeResizePointerReceiver rrpr = this.draggingTabs.get(w);
                if (rrpr != null) {
                    theDisplayOX = rrpr.lastSize.width;
                } else {
                    shouldRender = false;
                }
            }
            if (!shouldRender) {
                pos += tabW;
                continue;
            }
            if (UIBorderedElement.getMoveDownFlag(theme, base)) {
                try (Block bc = igd.openTranslate(0.0f, this.effectiveHeight / 8);){
                    UITabBar.drawTab(theme, base, theDisplayOX, 0, tabW, this.effectiveHeight, igd, w.contents.toString(), w, enBack, enFore);
                }
            } else {
                UITabBar.drawTab(theme, base, theDisplayOX, 0, tabW, this.effectiveHeight, igd, w.contents.toString(), w, enBack, enFore);
            }
            pos += tabW;
        }
    }

    private int calculateTabBarWidth(int atHeight) {
        FontManager fm = Theme.FM_GLOBAL.get(this);
        int tl = 0;
        Theme th = this.getTheme();
        for (Tab tab : this.tabs) {
            tl += UITabBar.getTabWidth(th, fm, tab, this.shortTabs, atHeight);
        }
        int extra = this.canSelectNone ? this.wantedHeight : 0;
        return tl + extra;
    }

    @Override
    protected void layoutRunImpl() {
        Size bounds = this.getSize();
        for (int pass = this.tabScroller == null ? 1 : 0; pass < (this.tabScroller == null ? 2 : 3); ++pass) {
            int lastWidth;
            boolean thisPassHasScrollbar = pass != 1;
            this.fullWantedHeight = this.wantedHeight;
            this.effectiveHeight = bounds.height;
            if (thisPassHasScrollbar) {
                if (!this.layoutContainsElement(this.tabScroller)) {
                    this.layoutAddElement(this.tabScroller);
                }
                int tsh = this.tabScroller.getWantedSize().height;
                this.effectiveHeight -= tsh;
                this.fullWantedHeight += tsh;
                this.tabScroller.setForcedBounds(this, new Rect(0, this.effectiveHeight, bounds.width, tsh));
            } else if (this.tabScroller != null && this.layoutContainsElement(this.tabScroller)) {
                this.layoutRemoveElement(this.tabScroller);
            }
            this.shortTabs = -1;
            int longestWidth = this.calculateTabBarWidth(this.effectiveHeight);
            int eScrollAreaX = Math.max(0, longestWidth - bounds.width);
            this.scrollAreaX = thisPassHasScrollbar ? eScrollAreaX : 0;
            if (this.tabScroller == null && (lastWidth = longestWidth) > bounds.width) {
                if (this.tabs.size() > 0) {
                    this.shortTabs = bounds.width / this.tabs.size();
                }
                lastWidth = this.calculateTabBarWidth(this.effectiveHeight);
            }
            if (pass == 0 ? eScrollAreaX > 0 : pass == 1 && eScrollAreaX == 0) break;
        }
    }

    @Override
    public int layoutGetHForW(int width) {
        if (this.tabScroller != null && width < this.calculateTabBarWidth(this.wantedHeight)) {
            return this.wantedHeight + this.tabScroller.getWantedSize().height;
        }
        return this.wantedHeight;
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        return new Size(this.calculateTabBarWidth(this.wantedHeight), this.wantedHeight);
    }

    protected int getScrollOffsetX() {
        if (this.tabScroller != null) {
            return -((int)(this.tabScroller.scrollPoint * (double)this.scrollAreaX));
        }
        return 0;
    }

    public double getScrollPoint() {
        return this.tabScroller.scrollPoint;
    }

    public void setScrollPoint(double point) {
        this.tabScroller.scrollPoint = point;
    }

    public void findReplacementTab() {
        if (this.canSelectNone) {
            this.parentView.selectTab(null);
        } else if (this.tabs.size() > 0) {
            this.parentView.selectTab(this.tabs.getFirst().contents);
        } else {
            this.parentView.selectTab(null);
        }
    }

    public boolean handleIncoming() {
        if (this.incomingTabs.size() > 0) {
            this.tabs.addAll(this.incomingTabs);
            this.incomingTabs.clear();
            if (this.parentView.selectedTab == null) {
                this.parentView.selectTab(this.tabs.getFirst().contents);
            }
            this.layoutRecalculateMetrics();
            return true;
        }
        return false;
    }

    private void tabReorderer(int x, Tab target) {
        FontManager fm = Theme.FM_GLOBAL.get(this);
        int oldIndex = this.tabs.indexOf(target);
        Theme th = this.getTheme();
        for (int pass = 0; pass < 2; ++pass) {
            int expectedIndex = -1;
            int selectedIndex = -1;
            int pos = this.getScrollOffsetX();
            int i = 0;
            for (Tab w : this.tabs) {
                int tabW = UITabBar.getTabWidth(th, fm, w, this.shortTabs, this.effectiveHeight);
                if (x < (pos += tabW) && expectedIndex == -1) {
                    expectedIndex = i;
                }
                if (target == w) {
                    selectedIndex = i;
                }
                ++i;
            }
            if (expectedIndex == -1) {
                expectedIndex = this.tabs.size() - 1;
            }
            if (selectedIndex == -1) {
                return;
            }
            Tab w = this.tabs.remove(selectedIndex);
            this.tabs.add(expectedIndex, w);
        }
        int newIndex = this.tabs.indexOf(target);
        if (newIndex != oldIndex) {
            this.tabReorderDidSomething = true;
        }
    }

    private void allTabReordersComplete() {
        if (this.tabReorderDidSomething) {
            this.parentView.handleTabReorderComplete();
        }
        this.tabReorderDidSomething = false;
    }

    public static int getTabWidth(Theme theme, FontManager fm, Tab window, int shortTab, int h) {
        int margin = h / 8;
        int tabExMargin = margin + margin / 2;
        int textHeight = h - margin * 2;
        if (shortTab == 0) {
            tabExMargin = 0;
        }
        window.updateTitleTextCache(theme, textHeight);
        int theWidth = window.titleTextCacheB.getChunk().cursorX(0) + tabExMargin * 2 + h * window.icons.length;
        if (shortTab != -1 && theWidth > shortTab) {
            return shortTab;
        }
        return theWidth;
    }

    public static int getHeight(int h) {
        return h + h / 8 * 2;
    }

    public static void drawTab(Theme theme, Theme.Attr<IBorder> border, int x, int y, int w, int h, IGrDriver igd, String text, Tab tab) {
        UITabBar.drawTab(theme, border, x, y, w, h, igd, text, tab, true, true);
    }

    public static void drawTab(Theme theme, Theme.Attr<IBorder> border, int x, int y, int w, int h, IGrDriver igd, String text, Tab tab, boolean enBack, boolean enFore) {
        int margin = h / 8;
        int textHeight = h - margin * 2;
        int tabExMargin = margin + margin / 2;
        int tabIcoMargin = h / 4;
        if (enBack) {
            UIBorderedElement.drawBorder(theme, igd, border, margin, x, y, w, h);
        }
        if (enFore) {
            tab.updateTitleTextCache(theme, textHeight);
            boolean blackText = UIBorderedElement.getBlackTextFlag(theme, border);
            TabIcon[] tabIconArray = null;
            try (Block b = igd.openScissor(x, y, w, h);){
                (blackText ? tab.titleTextCacheB : tab.titleTextCacheW).getChunk().renderRootAutoOffset(igd, x + tabExMargin, y + tabExMargin);
            }
            catch (Throwable object) {
                tabIconArray = object;
                throw object;
            }
            int icoBack = h;
            for (TabIcon i : tab.icons) {
                int size = h - tabIcoMargin * 2;
                int subMargin = tabIcoMargin / 2;
                igd.clearRect(0, 0, 0, x + w - (icoBack - tabIcoMargin + subMargin), y + tabIcoMargin - subMargin, size + subMargin * 2, size + subMargin * 2);
                i.draw(igd, x + w - (icoBack - tabIcoMargin), y + tabIcoMargin, size);
                icoBack += h;
            }
        }
    }

    public static boolean clickInTab(Tab wn, int x, int y, int w, int h) {
        int tabIcoMargin = h / 4;
        int icoBack = h;
        for (TabIcon i : wn.icons) {
            int size = h - tabIcoMargin * 2;
            Rect rc = new Rect(w - (icoBack - tabIcoMargin), tabIcoMargin, size, size);
            if (rc.contains(x, y)) {
                i.click(wn);
                return true;
            }
            icoBack += h;
        }
        return false;
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer pointer) {
        IPointerReceiver firstPtr = super.handleNewPointer(pointer);
        if (firstPtr != null) {
            return firstPtr;
        }
        Theme th = this.getTheme();
        FontManager fm = Theme.FM_GLOBAL.get(this);
        int x = pointer.getX();
        int y = pointer.getY();
        if (y < this.effectiveHeight) {
            int pos = this.getScrollOffsetX();
            for (final Tab w : this.tabs) {
                final int tabW = UITabBar.getTabWidth(th, fm, w, this.shortTabs, this.effectiveHeight);
                if (x < pos + tabW) {
                    if (UITabBar.clickInTab(w, x - pos, y, tabW, this.effectiveHeight)) {
                        return IPointerReceiver.NopPointerReceiver.I;
                    }
                    this.parentView.selectTab(w.contents);
                    if (this.canDragTabs) {
                        IPointerReceiver.RelativeResizePointerReceiver rrpr = new IPointerReceiver.RelativeResizePointerReceiver(pos, 0, new Consumer<Size>(){

                            @Override
                            public void accept(Size size) {
                                if (UITabBar.this.tabs.contains(w)) {
                                    UITabBar.this.tabReorderer(size.width + tabW / 2, w);
                                } else {
                                    UITabBar.this.draggingTabs.remove(w);
                                    if (UITabBar.this.draggingTabs.isEmpty()) {
                                        UITabBar.this.allTabReordersComplete();
                                    }
                                }
                            }
                        }){

                            @Override
                            public void handlePointerEnd(IPointer state) {
                                super.handlePointerEnd(state);
                                UITabBar.this.draggingTabs.remove(w);
                                if (UITabBar.this.draggingTabs.isEmpty()) {
                                    UITabBar.this.allTabReordersComplete();
                                }
                            }
                        };
                        this.draggingTabs.put(w, rrpr);
                        return rrpr;
                    }
                    return IPointerReceiver.NopPointerReceiver.I;
                }
                pos += tabW;
            }
            if (this.canSelectNone) {
                this.parentView.selectTab(null);
            }
        }
        return IPointerReceiver.NopPointerReceiver.I;
    }

    @Override
    public void handleMousewheel(int x, int y, boolean north) {
        if (this.tabScroller != null && y < this.fullWantedHeight) {
            this.tabScroller.handleMousewheel(x, y, north);
            return;
        }
        super.handleMousewheel(x, y, north);
    }

    public static class Tab {
        public final UIElement contents;
        public final TabIcon[] icons;
        public final TextTools.PlainCached titleTextCacheW = new TextTools.PlainCached();
        public final TextTools.PlainCached titleTextCacheB = new TextTools.PlainCached();

        public Tab(UIElement con, TabIcon[] ico) {
            this.contents = con;
            this.icons = ico;
        }

        public void updateTitleTextCache(Theme theme, int textHeight) {
            this.titleTextCacheW.text = this.titleTextCacheB.text = this.contents.toString();
            this.titleTextCacheW.blackText = false;
            this.titleTextCacheB.blackText = true;
            this.titleTextCacheW.font = this.titleTextCacheB.font = Theme.FM_GLOBAL.get(theme).getFontForText(this.titleTextCacheW.text, textHeight);
            this.titleTextCacheW.update();
            this.titleTextCacheB.update();
        }
    }

    public static interface TabIcon
    extends IIcon {
        public void click(Tab var1);
    }
}

