/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.layouts;

import gabien.ui.UIElement;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import org.eclipse.jdt.annotation.Nullable;

public class UISplitterLayout
extends UIElement.UIPanel {
    public final UIElement a;
    public final UIElement b;
    public final boolean vertical;
    public final double splitPoint;

    public UISplitterLayout(UIElement aA, UIElement bA, boolean v, int dividend, int divisor) {
        this(aA, bA, v, (double)dividend / (double)divisor);
    }

    public UISplitterLayout(UIElement aA, UIElement bA, boolean v, double weight) {
        this.vertical = v;
        this.a = aA;
        this.b = bA;
        this.layoutAddElement(this.a);
        this.layoutAddElement(this.b);
        this.splitPoint = weight;
        this.layoutRecalculateMetrics();
        this.setForcedBounds(null, new Rect(this.getWantedSize()));
    }

    public static UIElement produceSideAlignedList(boolean rd, boolean vertical, UIElement ... elements) {
        return UISplitterLayout.produceSideAlignedList(rd, vertical, elements, 0, elements.length);
    }

    public static UIElement produceSideAlignedList(boolean rd, boolean vertical, UIElement[] elements, int offset, int length) {
        if (length == 0) {
            throw new RuntimeException("no arguments");
        }
        if (length == 1) {
            return elements[offset];
        }
        if (rd) {
            UIElement remainder = UISplitterLayout.produceSideAlignedList(rd, vertical, elements, offset + 1, length - 1);
            return new UISplitterLayout(elements[offset], remainder, vertical, 1.0);
        }
        UIElement remainder = UISplitterLayout.produceSideAlignedList(rd, vertical, elements, offset, length - 1);
        return new UISplitterLayout(remainder, elements[offset + (length - 1)], vertical, 0.0);
    }

    private int getSplitPointPixels(int allSpace) {
        int bInitial;
        int aInitial;
        Size aWanted = this.a.getWantedSize();
        Size bWanted = this.b.getWantedSize();
        if (this.vertical) {
            aInitial = aWanted.height;
            bInitial = bWanted.height;
        } else {
            aInitial = aWanted.width;
            bInitial = bWanted.width;
        }
        return this.getSplitPointPixelsWithInitial(allSpace, aInitial, bInitial);
    }

    private int getSplitPointPixels(int allSpace, int breadth) {
        int bInitial;
        int aInitial;
        if (this.vertical) {
            aInitial = this.a.layoutGetHForW(breadth);
            bInitial = this.b.layoutGetHForW(breadth);
        } else {
            aInitial = this.a.layoutGetWForH(breadth);
            bInitial = this.b.layoutGetWForH(breadth);
        }
        return this.getSplitPointPixelsWithInitial(allSpace, aInitial, bInitial);
    }

    private int getSplitPointPixelsWithInitial(int allSpace, int aInitial, int bInitial) {
        int room = allSpace;
        int exactPos = (int)(this.splitPoint * (double)allSpace);
        if ((room -= aInitial + bInitial) >= 0) {
            boolean newAlg = exactPos >= aInitial && exactPos <= allSpace - bInitial;
            int oldAlg = (int)(this.splitPoint * (double)room) + aInitial;
            if (!newAlg) {
                exactPos = oldAlg;
            }
        } else {
            if (this.splitPoint == 1.0) {
                exactPos = allSpace - bInitial;
            } else if (this.splitPoint == 0.0) {
                exactPos = aInitial;
            }
            if (exactPos < 0 || exactPos > allSpace) {
                exactPos = allSpace / 2;
            }
        }
        return exactPos;
    }

    @Override
    public int layoutGetWForH(int height) {
        if (this.vertical) {
            int splitPx = this.getSplitPointPixels(height);
            int remainder = height - splitPx;
            return Math.max(this.a.layoutGetWForH(splitPx), this.b.layoutGetWForH(remainder));
        }
        return this.a.layoutGetWForH(height) + this.b.layoutGetWForH(height);
    }

    @Override
    public int layoutGetHForW(int width) {
        if (this.vertical) {
            return this.a.layoutGetHForW(width) + this.b.layoutGetHForW(width);
        }
        int splitPx = this.getSplitPointPixels(width);
        int remainder = width - splitPx;
        return Math.max(this.a.layoutGetHForW(splitPx), this.b.layoutGetHForW(remainder));
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        Size aWanted = this.a.getWantedSize();
        Size bWanted = this.b.getWantedSize();
        if (this.vertical) {
            return new Size(Math.max(aWanted.width, bWanted.width), aWanted.height + bWanted.height);
        }
        return new Size(aWanted.width + bWanted.width, Math.max(aWanted.height, bWanted.height));
    }

    @Override
    protected void layoutRunImpl() {
        int breadth;
        int allSpace;
        Size r = this.getSize();
        if (this.vertical) {
            allSpace = r.height;
            breadth = r.width;
        } else {
            allSpace = r.width;
            breadth = r.height;
        }
        int exactPos = this.getSplitPointPixels(allSpace, breadth);
        if (this.vertical) {
            this.a.setForcedBounds(this, new Rect(0, 0, r.width, exactPos));
            this.b.setForcedBounds(this, new Rect(0, exactPos, r.width, allSpace - exactPos));
        } else {
            this.a.setForcedBounds(this, new Rect(0, 0, exactPos, r.height));
            this.b.setForcedBounds(this, new Rect(exactPos, 0, allSpace - exactPos, r.height));
        }
    }
}

