/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.layouts;

import gabien.ui.UIElement;
import gabien.ui.elements.UIScrollbar;
import gabien.ui.layouts.UIBaseListOfStuffLayout;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;
import org.eclipse.jdt.annotation.Nullable;

public class UIScrollLayout
extends UIBaseListOfStuffLayout {
    public final UIScrollbar scrollbar;
    private int sbSize;
    private int scrollLength = 0;
    private double lastScrollPoint = -1.0;

    public UIScrollLayout(boolean vertical, int sc) {
        super(false);
        this.scrollbar = new UIScrollbar(vertical, sc);
        this.sbSize = sc;
    }

    public UIScrollLayout(boolean vertical, int sc, UIElement ... contents) {
        this(vertical, sc);
        this.panelsSet(contents);
        this.forceToRecommended();
    }

    public UIScrollLayout(boolean vertical, int sc, Iterable<UIElement> contents) {
        this(vertical, sc);
        this.panelsSet(contents);
        this.forceToRecommended();
    }

    private int getLengthForBreadth(int breadth) {
        int total = 0;
        Iterable<UIElement> contentsIterable = this.layoutGetElementsIterable();
        if (this.scrollbar.vertical) {
            for (UIElement p : contentsIterable) {
                if (p == this.scrollbar) continue;
                total += p.layoutGetHForW(breadth);
            }
        } else {
            for (UIElement p : contentsIterable) {
                if (p == this.scrollbar) continue;
                total += p.layoutGetWForH(breadth);
            }
        }
        return total;
    }

    private int getBreadthForLength(int length) {
        int defaultLength = this.scrollbar.vertical ? this.getWantedSize().height : this.getWantedSize().width;
        int defaultBreadth = this.scrollbar.vertical ? this.getWantedSize().width : this.getWantedSize().height;
        return length < defaultLength ? defaultBreadth + this.sbSize : defaultBreadth;
    }

    @Override
    public int layoutGetHForW(int width) {
        if (this.scrollbar.vertical) {
            return this.getLengthForBreadth(width);
        }
        return this.getBreadthForLength(width);
    }

    @Override
    public int layoutGetWForH(int height) {
        if (this.scrollbar.vertical) {
            return this.getBreadthForLength(height);
        }
        return this.getLengthForBreadth(height);
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        int idealLength = 0;
        int idealBreadth = 0;
        if (this.scrollbar.vertical) {
            for (UIElement p : this.layoutGetElementsIterable()) {
                if (p == this.scrollbar) continue;
                Size pw = p.getWantedSize();
                idealBreadth = Math.max(idealBreadth, pw.width);
                idealLength += pw.height;
            }
        } else {
            for (UIElement p : this.layoutGetElementsIterable()) {
                if (p == this.scrollbar) continue;
                Size pw = p.getWantedSize();
                idealBreadth = Math.max(idealBreadth, pw.height);
                idealLength += pw.width;
            }
        }
        if (this.scrollbar.vertical) {
            return new Size(idealBreadth, idealLength);
        }
        return new Size(idealLength, idealBreadth);
    }

    @Override
    protected void layoutRunImpl() {
        boolean hasScrollbar;
        Size r = this.getSize();
        int fullBreadth = this.scrollbar.vertical ? r.width : r.height;
        int fullLength = this.scrollbar.vertical ? r.height : r.width;
        this.scrollLength = this.getLengthForBreadth(fullBreadth);
        boolean bl = hasScrollbar = fullLength < this.scrollLength;
        if (hasScrollbar) {
            this.scrollLength = this.getLengthForBreadth(fullBreadth - this.sbSize);
            if (!this.layoutContainsElement(this.scrollbar)) {
                this.layoutAddElement(this.scrollbar);
            }
            if (this.scrollbar.vertical) {
                this.scrollbar.setForcedBounds(this, new Rect(r.width - this.sbSize, 0, this.sbSize, r.height));
            } else {
                this.scrollbar.setForcedBounds(this, new Rect(0, r.height - this.sbSize, r.width, this.sbSize));
            }
        } else if (this.layoutContainsElement(this.scrollbar)) {
            this.layoutRemoveElement(this.scrollbar);
        }
        if (hasScrollbar) {
            this.scrollbar.wheelScale = (double)fullLength / 4.0 / (double)this.scrollLength;
        }
        this.layoutScrollbounds();
    }

    public void setSBSize(int size) {
        this.sbSize = size;
        this.scrollbar.setSBSize(size);
        this.layoutRecalculateMetrics();
    }

    public int calcScrollHeight(Size bounds) {
        return Math.max(this.scrollLength - (this.scrollbar.vertical ? bounds.height : bounds.width), 0);
    }

    private void layoutScrollbounds() {
        this.lastScrollPoint = this.scrollbar.scrollPoint;
        Size bounds = this.getSize();
        int boundsLength = this.scrollbar.vertical ? bounds.height : bounds.width;
        int scrollHeight = this.calcScrollHeight(bounds);
        int appliedScrollbarSz = this.sbSize;
        int rY = (int)(-this.scrollbar.scrollPoint * (double)scrollHeight);
        if (!this.layoutContainsElement(this.scrollbar)) {
            rY = 0;
            appliedScrollbarSz = 0;
        }
        for (UIElement p : this.layoutGetElements()) {
            int elmLength;
            int breadth;
            if (p == this.scrollbar) continue;
            this.layoutSetElementVis(p, false);
            int oRY = rY;
            if (this.scrollbar.vertical) {
                breadth = bounds.width - appliedScrollbarSz;
                elmLength = p.layoutGetHForW(breadth);
                p.setForcedBounds(this, new Rect(0, rY, breadth, elmLength));
            } else {
                breadth = bounds.height - appliedScrollbarSz;
                elmLength = p.layoutGetWForH(breadth);
                p.setForcedBounds(this, new Rect(rY, 0, elmLength, breadth));
            }
            rY += elmLength;
            if (oRY <= -elmLength || oRY >= boundsLength) continue;
            this.layoutSetElementVis(p, true);
        }
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        if (this.lastScrollPoint != this.scrollbar.scrollPoint) {
            this.layoutScrollbounds();
        }
        super.update(deltaTime, selected, peripherals);
    }

    @Override
    public void handleMousewheel(int x, int y, boolean north) {
        if (!this.layoutContainsElement(this.scrollbar)) {
            super.handleMousewheel(x, y, north);
            return;
        }
        this.scrollbar.handleMousewheel(x, y, north);
    }
}

