/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.layouts;

import gabien.ui.UIElement;
import gabien.ui.layouts.UIBaseListOfStuffLayout;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import org.eclipse.jdt.annotation.Nullable;

public class UIListLayout
extends UIBaseListOfStuffLayout {
    public final boolean vertical;

    public UIListLayout(boolean vertical) {
        super(false);
        this.vertical = vertical;
    }

    public UIListLayout(boolean vertical, UIElement ... contents) {
        this(vertical);
        this.panelsSet(contents);
        this.forceToRecommended();
    }

    public UIListLayout(boolean vertical, Iterable<UIElement> contents) {
        this(vertical);
        this.panelsSet(contents);
        this.forceToRecommended();
    }

    private int getLengthForBreadth(int breadth) {
        int total = 0;
        Iterable<UIElement> contentsIterable = this.layoutGetElementsIterable();
        if (this.vertical) {
            for (UIElement p : contentsIterable) {
                total += p.layoutGetHForW(breadth);
            }
        } else {
            for (UIElement p : contentsIterable) {
                total += p.layoutGetWForH(breadth);
            }
        }
        return total;
    }

    private int getBreadthForLength(int length) {
        return this.vertical ? this.getWantedSize().width : this.getWantedSize().height;
    }

    @Override
    public int layoutGetHForW(int width) {
        if (this.vertical) {
            return this.getLengthForBreadth(width);
        }
        return this.getBreadthForLength(width);
    }

    @Override
    public int layoutGetWForH(int height) {
        if (this.vertical) {
            return this.getBreadthForLength(height);
        }
        return this.getLengthForBreadth(height);
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        int idealLength = 0;
        int idealBreadth = 0;
        if (this.vertical) {
            for (UIElement p : this.layoutGetElementsIterable()) {
                Size pw = p.getWantedSize();
                idealBreadth = Math.max(idealBreadth, pw.width);
                idealLength += pw.height;
            }
        } else {
            for (UIElement p : this.layoutGetElementsIterable()) {
                Size pw = p.getWantedSize();
                idealBreadth = Math.max(idealBreadth, pw.height);
                idealLength += pw.width;
            }
        }
        if (this.vertical) {
            return new Size(idealBreadth, idealLength);
        }
        return new Size(idealLength, idealBreadth);
    }

    @Override
    protected void layoutRunImpl() {
        Size bounds = this.getSize();
        int boundsLength = this.vertical ? bounds.height : bounds.width;
        int rY = 0;
        for (UIElement p : this.layoutGetElements()) {
            int elmLength;
            int breadth;
            this.layoutSetElementVis(p, false);
            int oRY = rY;
            if (this.vertical) {
                breadth = bounds.width;
                elmLength = p.layoutGetHForW(breadth);
                p.setForcedBounds(this, new Rect(0, rY, breadth, elmLength));
            } else {
                breadth = bounds.height;
                elmLength = p.layoutGetWForH(breadth);
                p.setForcedBounds(this, new Rect(rY, 0, elmLength, breadth));
            }
            rY += elmLength;
            if (oRY <= -elmLength || oRY >= boundsLength) continue;
            this.layoutSetElementVis(p, true);
        }
    }
}

