/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.render.IDrawable;
import gabien.render.IGrDriver;
import gabien.ui.UIElement;
import gabien.ui.UILayer;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;
import org.eclipse.jdt.annotation.Nullable;

public class UIThumbnail
extends UIElement {
    private final IDrawable viewedImage;
    private final int wantedW;
    private Rect drawRect;

    public UIThumbnail(IDrawable im) {
        this(im, (int)im.getRegionWidth());
    }

    public UIThumbnail(IDrawable im, int wanted) {
        super(wanted, (int)(im.getRegionHeight() * (float)wanted / im.getRegionWidth()));
        this.wantedW = wanted;
        this.viewedImage = im;
        this.drawRect = new Rect(this.getWantedSize());
    }

    public static Rect getDrawRect(Size bounds, float contentsW, float contentsH) {
        double scale = Math.min((double)bounds.width / (double)contentsW, (double)bounds.height / (double)contentsH);
        int bw = (int)((double)contentsW * scale);
        int bh = (int)((double)contentsH * scale);
        int bx = (bounds.width - bw) / 2;
        int by = (bounds.height - bh) / 2;
        return new Rect(bx, by, bw, bh);
    }

    @Override
    protected void layoutRunImpl() {
        float irW = this.viewedImage.getRegionWidth();
        float irH = this.viewedImage.getRegionHeight();
        this.drawRect = UIThumbnail.getDrawRect(this.getSize(), irW, irH);
    }

    @Override
    public int layoutGetHForW(int width) {
        float irW = this.viewedImage.getRegionWidth();
        float irH = this.viewedImage.getRegionHeight();
        int efW = Math.min(width, this.wantedW);
        return (int)(irH * (float)efW / irW);
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        float irW = this.viewedImage.getRegionWidth();
        float irH = this.viewedImage.getRegionHeight();
        return new Size(this.wantedW, (int)(irH * (float)this.wantedW / irW));
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
    }

    @Override
    public void renderLayer(IGrDriver igd, UILayer layer) {
        if (layer != UILayer.Content) {
            return;
        }
        this.viewedImage.drawScissoredTo(this.drawRect.x, this.drawRect.y, this.drawRect.width, this.drawRect.height, igd);
    }
}

