/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.render.IGrDriver;
import gabien.ui.elements.UIBorderedElement;
import gabien.ui.elements.UIButton;
import gabien.ui.elements.UILabel;
import gabien.uslx.append.Size;
import org.eclipse.jdt.annotation.Nullable;

public class UITextButton
extends UIButton<UITextButton> {
    private String text;
    private final UILabel.Contents contents;
    public boolean centred;

    public UITextButton(String tex, int h, Runnable click) {
        super(UIBorderedElement.getRecommendedBorderWidth(h));
        this.text = tex;
        this.onClick = click;
        this.contents = new UILabel.Contents(h, "", tex, this.getBorderWidth(), this.getTheme());
        this.forceToRecommended();
    }

    public void setText(String text) {
        if (this.text.equals(text)) {
            return;
        }
        this.text = text;
        this.contents.setText(text);
        this.layoutRecalculateMetrics();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void onThemeChanged() {
        super.onThemeChanged();
        this.contents.setTheme(this.getTheme());
        this.layoutRecalculateMetrics();
    }

    @Override
    public int layoutGetHForW(int width) {
        return this.contents.getHForW(width);
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        return this.contents.getWantedSize();
    }

    @Override
    public void renderContents(boolean textBlack, IGrDriver igd) {
        this.contents.update(this.getSize());
        this.contents.render(textBlack, 0, 0, igd, this.centred);
    }

    public UITextButton centred() {
        this.centred = true;
        return this;
    }
}

