/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.ui.IPointerReceiver;
import gabien.ui.elements.UILabel;
import gabien.ui.theming.Theme;
import gabien.uslx.append.EmptyLambdas;
import gabien.uslx.append.Rect;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import gabien.wsi.ITextEditingSession;
import java.util.function.Function;

public class UITextBox
extends UILabel {
    private String textAsSeenByProgram;
    public Runnable onEdit = EmptyLambdas.emptyRunnable;
    public Function<String, String> feedback;
    public boolean multiLine;
    private boolean tempDisableSelection = false;
    private ITextEditingSession editingSession;

    public UITextBox(String text, int h) {
        super(text, h);
        this.textAsSeenByProgram = text;
        this.setBorderType(Theme.B_TEXTBOX);
    }

    public UITextBox setMultiLine() {
        this.multiLine = true;
        return this;
    }

    @Override
    public void setText(String text) {
        this.textAsSeenByProgram = text;
        if (this.editingSession != null) {
            this.editingSession.setText(text);
        }
        super.setText(text);
    }

    @Override
    public String getText() {
        return this.textAsSeenByProgram;
    }

    @Override
    public void updateContents(double deltaTime, boolean selected, IPeripherals peripherals) {
        boolean bl = !this.tempDisableSelection;
        String textBeingEdited = super.getText();
        if (selected &= bl) {
            if (this.editingSession == null) {
                this.editingSession = peripherals.openTextEditingSession(textBeingEdited, this.multiLine, this.contents.textHeight, this.feedback);
            }
            Rect crib = this.getContentsRelativeInputBounds();
            String ss = this.editingSession.maintain(crib.x, crib.y, crib.width, crib.height);
            if (!this.multiLine && this.editingSession.isEnterJustPressed()) {
                this.editingSession.endSession();
                this.setText(ss);
                this.onEdit.run();
                peripherals.clearKeys();
                this.tempDisableSelection = true;
            }
            if (this.editingSession != null && this.editingSession.isSessionDead()) {
                this.tempDisableSelection = true;
                this.closeOffSession();
            }
        } else if (this.editingSession != null) {
            if (this.multiLine) {
                this.editingSession.endSession();
                this.setText(textBeingEdited);
                this.onEdit.run();
            }
            this.closeOffSession();
        }
        this.setBorderType(selected ? Theme.B_TEXTBOXF : Theme.B_TEXTBOX);
        super.updateContents(deltaTime, selected, peripherals);
    }

    @Override
    public void setAttachedToRoot(boolean attached) {
        super.setAttachedToRoot(attached);
        if (!attached) {
            this.closeOffSession();
        }
    }

    private void closeOffSession() {
        if (this.editingSession != null) {
            this.editingSession.endSession();
            this.editingSession = null;
            super.setText(this.textAsSeenByProgram);
        }
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer state) {
        this.tempDisableSelection = false;
        return super.handleNewPointer(state);
    }
}

