/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.render.IGrDriver;
import gabien.ui.IPointerReceiver;
import gabien.ui.UIElement;
import gabien.ui.UILayer;
import gabien.ui.elements.UIBorderedElement;
import gabien.ui.theming.IBorder;
import gabien.ui.theming.IIcon;
import gabien.ui.theming.Theme;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import org.eclipse.jdt.annotation.Nullable;

public class UIScrollbar
extends UIElement {
    public double scrollPoint = 0.0;
    public double wheelScale = 0.1;
    public final boolean vertical;
    private int barSize;
    private int barLength;
    private int carriageBorder;
    private int carriageMargin;
    private int carriageFloorLength;
    private int nubBorder;
    private int nubSize;
    private double carriageFloorNubPositionScalingFactor;
    private double negativeButtonTimer;
    private double positiveButtonTimer;
    private int sbSize;
    private Rect boxNegative = Rect.ZERO;
    @Nullable
    private Rect boxCarriage;
    @Nullable
    private Rect boxCarriageFloor;
    private Rect boxPositive = Rect.ZERO;

    public UIScrollbar(boolean vert, int sc) {
        this.vertical = vert;
        this.setSBSize(sc);
        this.setForcedBounds(null, new Rect(this.getWantedSize()));
    }

    @Override
    protected void layoutRunImpl() {
        Size size = this.getSize();
        this.barSize = this.vertical ? size.width : size.height;
        this.barLength = this.vertical ? size.height : size.width;
        this.carriageBorder = this.barSize / 8;
        int carriageLength = this.barLength - this.barSize * 2;
        this.carriageMargin = this.carriageBorder;
        if (UIBorderedElement.getMoveDownFlag(this.getTheme(), Theme.B_SBNUB)) {
            this.carriageMargin = 0;
        }
        this.nubSize = this.barSize - this.carriageMargin * 2;
        int n3 = this.nubSize / 3;
        if (n3 < 3) {
            n3 = 1;
        }
        this.nubBorder = n3 = n3 / 3 * 3;
        if (carriageLength < this.barSize * 2) {
            this.boxCarriage = null;
            this.boxCarriageFloor = null;
            if (this.vertical) {
                this.boxNegative = new Rect(0, 0, this.barSize, this.barLength >> 1);
                this.boxPositive = new Rect(0, this.boxNegative.height, this.barSize, this.barLength - this.boxNegative.height);
            } else {
                this.boxNegative = new Rect(0, 0, this.barLength >> 1, this.barSize);
                this.boxPositive = new Rect(this.boxNegative.width, 0, this.barLength - this.boxNegative.width, this.barSize);
            }
        } else {
            this.boxNegative = new Rect(0, 0, this.barSize, this.barSize);
            if (this.vertical) {
                this.boxPositive = new Rect(0, this.barLength - this.barSize, this.barSize, this.barSize);
                this.boxCarriage = new Rect(0, this.barSize, this.barSize, carriageLength);
            } else {
                this.boxPositive = new Rect(this.barLength - this.barSize, 0, this.barSize, this.barSize);
                this.boxCarriage = new Rect(this.barSize, 0, carriageLength, this.barSize);
            }
            this.boxCarriageFloor = new Rect(this.boxCarriage.x + this.carriageMargin, this.boxCarriage.y + this.carriageMargin, this.boxCarriage.width - this.carriageMargin * 2, this.boxCarriage.height - this.carriageMargin * 2);
            this.carriageFloorLength = this.vertical ? this.boxCarriageFloor.height : this.boxCarriageFloor.width;
            this.carriageFloorNubPositionScalingFactor = this.carriageFloorLength - this.nubSize;
        }
    }

    @Override
    public void renderLayer(IGrDriver igd, UILayer layer) {
        if (layer != UILayer.Content) {
            return;
        }
        Theme theme = this.getTheme();
        this.drawNPB(theme, igd, this.negativeButtonTimer, this.boxNegative, this.vertical ? Theme.IC_ARROW_UP : Theme.IC_ARROW_LEFT);
        this.drawNPB(theme, igd, this.positiveButtonTimer, this.boxPositive, this.vertical ? Theme.IC_ARROW_DOWN : Theme.IC_ARROW_RIGHT);
        if (this.boxCarriage != null) {
            UIBorderedElement.drawBorder(theme, igd, Theme.B_SBTRAY, this.carriageBorder, this.boxCarriage);
            int nubX = this.boxCarriageFloor.x;
            int nubY = this.boxCarriageFloor.y;
            int nubPoint = (int)Math.ceil(this.scrollPoint * this.carriageFloorNubPositionScalingFactor);
            if (this.vertical) {
                nubY += nubPoint;
            } else {
                nubX += nubPoint;
            }
            UIBorderedElement.drawBorder(theme, igd, Theme.B_SBNUB, this.nubBorder, nubX, nubY, this.nubSize, this.nubSize);
        }
    }

    private void drawNPB(Theme theme, IGrDriver igd, double timer, Rect box, Theme.Attr<IIcon> icoAttr) {
        boolean down = timer > 0.0;
        Theme.Attr<IBorder> borderId = down ? Theme.B_BTNP : Theme.B_BTN;
        int iconSize = Math.min(box.width, box.height) - this.carriageBorder * 2;
        int yOffset = 0;
        if (UIBorderedElement.getMoveDownFlag(theme, borderId)) {
            yOffset += this.carriageBorder;
        }
        UIBorderedElement.drawBorder(theme, igd, borderId, this.carriageBorder, box.x, box.y + yOffset, box.width, box.height);
        IIcon icon = icoAttr.get(this.getTheme());
        icon.draw(igd, box.x + (box.width - iconSize) / 2, box.y + yOffset + (box.height - iconSize) / 2, iconSize);
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        if (this.negativeButtonTimer >= 0.0) {
            this.negativeButtonTimer -= deltaTime;
        }
        if (this.positiveButtonTimer >= 0.0) {
            this.positiveButtonTimer -= deltaTime;
        }
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer state) {
        if (this.boxCarriage != null && this.boxCarriage.contains(state.getX(), state.getY())) {
            return new IPointerReceiver(){

                @Override
                public void handlePointerBegin(IPointer state) {
                }

                @Override
                public void handlePointerUpdate(IPointer pointer) {
                    if (UIScrollbar.this.boxCarriage == null) {
                        return;
                    }
                    int source = UIScrollbar.this.vertical ? pointer.getY() - ((UIScrollbar)UIScrollbar.this).boxCarriageFloor.y : pointer.getX() - ((UIScrollbar)UIScrollbar.this).boxCarriageFloor.x;
                    UIScrollbar.this.scrollPoint = (double)(source -= UIScrollbar.this.nubSize / 2) / UIScrollbar.this.carriageFloorNubPositionScalingFactor;
                    if (UIScrollbar.this.scrollPoint < 0.0) {
                        UIScrollbar.this.scrollPoint = 0.0;
                    }
                    if (UIScrollbar.this.scrollPoint > 1.0) {
                        UIScrollbar.this.scrollPoint = 1.0;
                    }
                }

                @Override
                public void handlePointerEnd(IPointer state) {
                }
            };
        }
        if (this.boxNegative.contains(state.getX(), state.getY())) {
            return new IPointerReceiver(){

                @Override
                public void handlePointerBegin(IPointer state) {
                    UIScrollbar.this.handleMousewheel(0, 0, true);
                    UIScrollbar.this.negativeButtonTimer = 0.25;
                }

                @Override
                public void handlePointerUpdate(IPointer state) {
                }

                @Override
                public void handlePointerEnd(IPointer state) {
                }
            };
        }
        if (this.boxPositive.contains(state.getX(), state.getY())) {
            return new IPointerReceiver(){

                @Override
                public void handlePointerBegin(IPointer state) {
                    UIScrollbar.this.handleMousewheel(0, 0, false);
                    UIScrollbar.this.positiveButtonTimer = 0.25;
                }

                @Override
                public void handlePointerUpdate(IPointer state) {
                }

                @Override
                public void handlePointerEnd(IPointer state) {
                }
            };
        }
        return null;
    }

    @Override
    public void handleMousewheel(int x, int y, boolean north) {
        this.scrollPoint += north ? -this.wheelScale : this.wheelScale;
        if (this.scrollPoint < 0.0) {
            this.scrollPoint = 0.0;
        }
        if (this.scrollPoint > 1.0) {
            this.scrollPoint = 1.0;
        }
    }

    public void setSBSize(int sbSize) {
        this.sbSize = sbSize;
        this.layoutRecalculateMetrics();
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        return new Size(this.vertical ? this.sbSize : this.sbSize * 4, this.vertical ? this.sbSize * 4 : this.sbSize);
    }
}

