/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.ui.IPointerReceiver;
import gabien.ui.elements.UILabel;
import gabien.ui.theming.Theme;
import gabien.uslx.append.EmptyLambdas;
import gabien.uslx.append.Rect;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import gabien.wsi.ITextEditingSession;

public class UINumberBox
extends UILabel {
    private long editingCNumber = 0L;
    private long editingNLast = 0L;
    private long number = 0L;
    public boolean readOnly = false;
    public Runnable onEdit = EmptyLambdas.emptyRunnable;
    private boolean tempDisableSelection = false;
    private ITextEditingSession editingSession;

    public UINumberBox(long number, int h) {
        this(number, h, "0000");
    }

    public UINumberBox(long number, int h, String spacer) {
        super(Long.toString(number), h, spacer);
        this.number = number;
        this.setBorderType(Theme.B_TEXTBOX);
        this.alignX = 2;
    }

    @Override
    public void setText(String didThing) {
        this.setNumber(Long.parseLong(didThing));
    }

    public void setNumber(long v) {
        this.number = v;
        super.setText(Long.toString(v));
    }

    public long getNumber() {
        return this.number;
    }

    @Override
    public void updateContents(double deltaTime, boolean selected, IPeripherals peripherals) {
        selected &= !this.tempDisableSelection;
        if (this.number != this.editingNLast) {
            this.editingCNumber = this.number;
            this.editingNLast = this.number;
            super.setText(Long.toString(this.number));
        } else if (this.number != this.editingCNumber && !selected) {
            this.number = this.editingCNumber;
            super.setText(Long.toString(this.number));
        }
        if (selected && !this.readOnly) {
            if (this.editingSession == null) {
                this.editingSession = peripherals.openTextEditingSession(String.valueOf(this.number), false, this.contents.textHeight, null);
            }
            Rect crib = this.getContentsRelativeInputBounds();
            String ss = this.editingSession.maintain(crib.x, crib.y, crib.width, crib.height);
            int lastMinusIdx = ss.lastIndexOf("-");
            boolean doInvertLater = false;
            if (lastMinusIdx > 0) {
                String pre = ss.substring(0, lastMinusIdx);
                String post = ss.substring(lastMinusIdx + 1);
                ss = pre + post;
                doInvertLater = true;
            }
            long newNum = 0L;
            try {
                newNum = Long.parseLong(ss);
                if (doInvertLater) {
                    newNum = -newNum;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.editingNLast = this.number = newNum;
            String ourIdeal = String.valueOf(this.number);
            if (!ourIdeal.equals(ss)) {
                this.editingSession.setText(ourIdeal);
            }
            if (this.editingSession.isEnterJustPressed()) {
                this.editingCNumber = this.number;
                this.onEdit.run();
                peripherals.clearKeys();
                this.tempDisableSelection = true;
            } else if (this.editingSession.isSessionDead()) {
                this.tempDisableSelection = true;
            }
            super.setText(Long.toString(this.number));
        } else if (this.editingSession != null) {
            this.editingSession.endSession();
            this.editingSession = null;
        }
        this.setBorderType(selected ? Theme.B_TEXTBOXF : Theme.B_TEXTBOX);
        super.updateContents(deltaTime, selected, peripherals);
    }

    @Override
    public void setAttachedToRoot(boolean attached) {
        super.setAttachedToRoot(attached);
        if (this.editingSession != null && !attached) {
            this.editingSession.endSession();
            this.editingSession = null;
        }
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer state) {
        this.tempDisableSelection = false;
        return super.handleNewPointer(state);
    }
}

