/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.GaBIEnUI;
import gabien.render.IGrDriver;
import gabien.text.TextTools;
import gabien.ui.FontManager;
import gabien.ui.LAFChain;
import gabien.ui.elements.UIBorderedElement;
import gabien.ui.theming.IBorder;
import gabien.ui.theming.Theme;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;
import org.eclipse.jdt.annotation.Nullable;

public class UILabel
extends UIBorderedElement {
    private String text;
    protected final Contents contents;
    public int alignX;
    public int alignY;

    public UILabel(String txt, int h) {
        this(txt, h, "");
    }

    public UILabel(String txt, int h, String spacer) {
        super(Theme.B_LABEL, UILabel.getRecommendedBorderWidth(h));
        this.text = txt;
        this.contents = new Contents(h, spacer, txt, this.getBorderWidth(), this.getTheme());
        this.forceToRecommended();
    }

    public UILabel centred() {
        this.alignX = 1;
        this.alignY = 1;
        return this;
    }

    @Override
    public void updateContents(double deltaTime, boolean selected, IPeripherals peripherals) {
    }

    @Override
    public void onThemeChanged() {
        super.onThemeChanged();
        this.contents.setTheme(this.getTheme());
        this.layoutRecalculateMetrics();
    }

    @Override
    public int layoutGetHForW(int width) {
        return this.contents.getHForW(width);
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        return this.contents.getWantedSize();
    }

    @Override
    public void renderContents(boolean textBlack, IGrDriver igd) {
        this.contents.update(this.getSize());
        this.contents.render(textBlack, 0, 0, igd, this.alignX, this.alignY);
    }

    public void setText(String didThing) {
        if (didThing.equals(this.text)) {
            return;
        }
        this.text = didThing;
        this.contents.setText(this.text);
        this.layoutRecalculateMetrics();
    }

    public String getText() {
        return this.text;
    }

    public static int drawLabel(Theme theme, IGrDriver igd, int wid, int ox, int oy, String string, Theme.Attr<IBorder> mode, int height, TextTools.PlainCached cache) {
        return UILabel.drawLabel(theme, igd, wid, ox, oy, string, mode, height, cache, true, true);
    }

    public static int drawLabel(Theme theme, IGrDriver igd, int wid, int ox, int oy, String string, Theme.Attr<IBorder> mode, int height, TextTools.PlainCached cache, boolean enBack, boolean enFore) {
        int h = UIBorderedElement.getRecommendedBorderWidth(height);
        int h2 = height + h * 2 - height / 8;
        if (enBack) {
            UIBorderedElement.drawBorder(theme, igd, mode, h, ox, oy, wid, h2);
        }
        if (enFore) {
            FontManager fm = Theme.FM_GLOBAL.get(theme);
            cache.font = fm.getFontForText(string, height);
            cache.blackText = UIBorderedElement.getBlackTextFlag(theme, mode);
            cache.text = string;
            cache.update();
            cache.getChunk().renderRootAutoOffset(igd, ox + h, oy + h);
        }
        return wid;
    }

    public static class StatusLine {
        public LAFChain themeSource = GaBIEnUI.sysThemeRoot;
        private Contents statusLine;
        private Size lastSize = new Size(0, 0);
        private int height = 0;

        public void draw(String text, int textHeight, IGrDriver igd, int x, int y, int w) {
            if (this.statusLine == null) {
                this.statusLine = new Contents(textHeight);
            } else if (this.statusLine.textHeight != textHeight) {
                this.statusLine = new Contents(textHeight);
            }
            int bw = UIBorderedElement.getRecommendedBorderWidth(textHeight);
            this.pokeLastSize(w, this.height);
            Theme theme = this.themeSource.getTheme();
            this.statusLine.setText(text);
            this.statusLine.setBorderWidth(bw);
            this.statusLine.setTheme(theme);
            Size sz = this.statusLine.update(this.lastSize);
            if (sz != null) {
                this.height = ((Contents)this.statusLine).lastActSize.height;
                this.pokeLastSize(w, this.height);
            }
            UIBorderedElement.drawBorder(theme, igd, Theme.B_LABEL, bw, x, y, w, this.height);
            boolean statusLineBT = UIBorderedElement.getBlackTextFlag(theme, Theme.B_LABEL);
            this.statusLine.render(statusLineBT, x, y, igd, false);
        }

        private void pokeLastSize(int w, int h) {
            if (this.lastSize.width != w || this.lastSize.height != h) {
                this.lastSize = new Size(w, h);
            }
        }
    }

    public static class Contents {
        private String textAsSet = "";
        private int borderWidthAsSet;
        private Theme themeAsSet = Theme.ROOT;
        private Size nsdpSpacerSize = Size.ZERO;
        private Size nsdpWantedSize = Size.ZERO;
        private boolean nsdpChangedSinceUpdate = true;
        private String textFormatted = "";
        private Size lastSize = Size.ZERO;
        private Size lastActSize = Size.ZERO;
        private int lastBw = 1;
        private TextTools.PlainCached paragraph = new TextTools.PlainCached();
        public final int textHeight;
        public final String spacerText;

        public Contents(int th) {
            this(th, "");
        }

        public Contents(int th, String st) {
            this(th, st, "", 1, Theme.ROOT);
        }

        public Contents(int th, String st, String text, int bw, Theme theme) {
            this.textHeight = th;
            this.spacerText = st;
            this.textAsSet = text;
            this.borderWidthAsSet = bw;
            this.themeAsSet = theme;
            this.recalculateNSDP();
        }

        public void setText(String text) {
            if (this.textAsSet.equals(text)) {
                return;
            }
            this.textAsSet = text;
            this.recalculateNSDP();
        }

        public void setBorderWidth(int bw) {
            if (this.borderWidthAsSet == bw) {
                return;
            }
            this.borderWidthAsSet = bw;
            this.recalculateNSDP();
        }

        public void setTheme(Theme theme) {
            if (this.themeAsSet == theme) {
                return;
            }
            this.themeAsSet = theme;
            this.recalculateNSDP();
        }

        private void recalculateNSDP() {
            Size sz2 = null;
            Size a = UIBorderedElement.getRecommendedTextSize(this.themeAsSet, this.textAsSet, this.textHeight, this.borderWidthAsSet);
            this.nsdpSpacerSize = UIBorderedElement.getRecommendedTextSize(this.themeAsSet, this.spacerText, this.textHeight, this.borderWidthAsSet);
            sz2 = a;
            this.nsdpWantedSize = sz2 = sz2.sizeMax(this.nsdpSpacerSize);
            this.nsdpChangedSinceUpdate = true;
        }

        public int getHForW(int width) {
            FontManager fm = Theme.FM_GLOBAL.get(this.themeAsSet);
            String formattedText = fm.formatTextFor(this.textAsSet, this.textHeight, width - this.borderWidthAsSet * 2);
            return UIBorderedElement.getRecommendedTextSize((Theme)this.themeAsSet, (String)formattedText, (int)this.textHeight, (int)this.borderWidthAsSet).height;
        }

        public Size getWantedSize() {
            return this.nsdpWantedSize;
        }

        public Size update(Size sz) {
            FontManager fm = Theme.FM_GLOBAL.get(this.themeAsSet);
            if (this.nsdpChangedSinceUpdate || !this.lastSize.sizeEquals(sz)) {
                this.lastSize = sz;
                this.lastBw = this.borderWidthAsSet;
                this.textFormatted = fm.formatTextFor(this.textAsSet, this.textHeight, sz.width - this.borderWidthAsSet * 2);
                this.lastActSize = UIBorderedElement.getRecommendedTextSize(this.themeAsSet, this.textFormatted, this.textHeight, this.borderWidthAsSet);
                this.paragraph.font = fm.getFontForText(this.textFormatted, this.textHeight);
                this.paragraph.text = this.textFormatted;
                this.nsdpChangedSinceUpdate = false;
                return this.nsdpWantedSize;
            }
            return null;
        }

        public void render(boolean blackText, int x, int y, IGrDriver igd, boolean centre) {
            this.render(blackText, x, y, igd, centre ? 1 : 0, centre ? 1 : 0);
        }

        public void render(boolean blackText, int x, int y, IGrDriver igd, int alignX, int alignY) {
            x += (this.lastSize.width - this.lastActSize.width) * alignX / 2;
            y += (this.lastSize.height - this.lastActSize.height) * alignY / 2;
            this.paragraph.blackText = blackText;
            this.paragraph.update();
            this.paragraph.getChunk().renderRootAutoOffset(igd, x += this.lastBw, y += this.lastBw);
        }
    }
}

