/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.GaBIEn;
import gabien.ui.IPointerReceiver;
import gabien.ui.elements.UILabel;
import gabien.ui.theming.Theme;
import gabien.uslx.append.Rect;
import gabien.wsi.IDesktopPeripherals;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import gabien.wsi.ITextEditingSession;
import java.util.function.Consumer;

public class UIChatBox
extends UILabel {
    private String history = "";
    public Consumer<String> onSubmit = text -> {};
    private boolean tempDisableSelection = false;
    private ITextEditingSession editingSession;

    public UIChatBox(String text2, int h) {
        super(text2, h);
        this.setBorderType(Theme.B_TEXTBOX);
    }

    @Override
    public void updateContents(double deltaTime, boolean selected, IPeripherals peripherals) {
        if (selected &= !this.tempDisableSelection) {
            String text = this.getText();
            if (this.editingSession == null) {
                this.editingSession = peripherals.openTextEditingSession(text, false, this.contents.textHeight, null);
            }
            Rect crib = this.getContentsRelativeInputBounds();
            if (peripherals instanceof IDesktopPeripherals && ((IDesktopPeripherals)peripherals).isKeyJustPressed(88)) {
                this.editingSession.setText(this.history);
            }
            text = this.editingSession.maintain(crib.x, crib.y, crib.width, crib.height);
            if (this.editingSession.isEnterJustPressed()) {
                this.history = text;
                text = "";
                this.onSubmit.accept(this.history);
                this.editingSession.endSession();
                this.editingSession = null;
                if (GaBIEn.singleWindowApp()) {
                    this.tempDisableSelection = true;
                }
            }
            this.setText(text);
            if (this.editingSession != null && this.editingSession.isSessionDead()) {
                this.tempDisableSelection = true;
                this.editingSession = null;
            }
        } else if (this.editingSession != null && this.editingSession != null) {
            this.editingSession.endSession();
            this.editingSession = null;
        }
        this.setBorderType(selected ? Theme.B_TEXTBOXF : Theme.B_TEXTBOX);
        super.updateContents(deltaTime, selected, peripherals);
    }

    @Override
    public void setAttachedToRoot(boolean attached) {
        super.setAttachedToRoot(attached);
        if (this.editingSession != null && !attached) {
            this.editingSession.endSession();
            this.editingSession = null;
        }
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer state) {
        this.tempDisableSelection = false;
        return super.handleNewPointer(state);
    }
}

