/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.ui.IPointerReceiver;
import gabien.ui.elements.UIBorderedElement;
import gabien.ui.theming.Theme;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;

public abstract class UIButton<ThisClass extends UIButton<?>>
extends UIBorderedElement {
    public Runnable onClick;
    public double pressedTime = 0.0;
    public boolean state = false;
    public boolean toggle = false;

    public UIButton(int bw) {
        super(Theme.B_BTN, bw);
    }

    public ThisClass togglable(boolean st) {
        this.state = st;
        this.toggle = true;
        return (ThisClass)this;
    }

    @Override
    public void updateContents(double deltaTime, boolean selected, IPeripherals peripherals) {
        if (this.pressedTime > 0.0) {
            this.pressedTime -= deltaTime;
            if (this.pressedTime <= 0.0) {
                this.state = false;
            }
        }
        this.setBorderType(this.state ? Theme.B_BTNP : Theme.B_BTN);
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer stat) {
        if (stat.getType() == IPointer.PointerType.Generic) {
            if (this.toggle) {
                this.state = !this.state;
            } else {
                this.enableStateForClick();
            }
            if (this.onClick != null) {
                this.onClick.run();
            }
        }
        return super.handleNewPointer(stat);
    }

    public void enableStateForClick() {
        this.state = true;
        this.pressedTime = 0.5;
    }
}

