/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.render.IGrDriver;
import gabien.ui.FontManager;
import gabien.ui.UIElement;
import gabien.ui.UILayer;
import gabien.ui.theming.IBorder;
import gabien.ui.theming.Theme;
import gabien.uslx.append.Block;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;

public abstract class UIBorderedElement
extends UIElement {
    private Theme.Attr<IBorder> borderType;
    private final int borderWidth;
    private Rect contentsRelativeInputBounds;
    private IBorder border;

    public UIBorderedElement(Theme.Attr<IBorder> bt, int bw) {
        this.borderType = bt;
        this.borderWidth = bw;
        this.updateBorder();
    }

    public UIBorderedElement(Theme.Attr<IBorder> bt, int bw, int w, int h) {
        super(w + bw * 2, h + bw * 2);
        this.borderType = bt;
        this.borderWidth = bw;
        this.updateBorder();
    }

    public static int getRecommendedBorderWidth(int textHeight) {
        return Math.max(1, textHeight / 8);
    }

    public static Size getRecommendedTextSize(Theme theme, String text, int textHeight) {
        return UIBorderedElement.getRecommendedTextSize(theme, text, textHeight, UIBorderedElement.getRecommendedBorderWidth(textHeight));
    }

    public static Size getRecommendedTextSize(Theme theme, String text, int textHeight, int bs) {
        FontManager fm = Theme.FM_GLOBAL.get(theme);
        Size s = fm.getTextSize(text, textHeight);
        return new Size(s.width + bs * 2, s.height + bs * 2);
    }

    public static int getBorderedTextHeight(Theme theme, int textHeight) {
        return UIBorderedElement.getBorderedTextHeight(theme, textHeight, UIBorderedElement.getRecommendedBorderWidth(textHeight));
    }

    public static int getBorderedTextHeight(Theme theme, int textHeight, int bs) {
        FontManager fm = Theme.FM_GLOBAL.get(theme);
        return fm.getFontSizeGeneralContentHeight(textHeight) + bs * 2;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderType(Theme.Attr<IBorder> bt) {
        if (bt != this.borderType) {
            this.borderType = bt;
            this.updateBorder();
        }
    }

    @Override
    public void onThemeChanged() {
        this.updateBorder();
    }

    private void updateBorder() {
        this.border = this.borderType.get(this);
        this.updateContentsRelativeInputBounds();
    }

    private void updateContentsRelativeInputBounds() {
        int bw;
        int bwy = bw = this.borderWidth;
        if (this.border.getFlag(1)) {
            bwy *= 2;
        }
        Size sz = this.getSize();
        this.contentsRelativeInputBounds = new Rect(-bw, -bwy, sz.width, sz.height);
    }

    protected Rect getContentsRelativeInputBounds() {
        return this.contentsRelativeInputBounds;
    }

    @Override
    protected void layoutRunImpl() {
        this.updateContentsRelativeInputBounds();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void renderLayer(IGrDriver igd, UILayer layer) {
        if (layer != UILayer.Base && layer != UILayer.Content) {
            return;
        }
        Size s = this.getSize();
        boolean black = this.border.getFlag(8);
        if (this.border.getFlag(1)) {
            try (Block b = igd.openTranslate(0.0f, this.getBorderWidth());){
                if (layer == UILayer.Base) {
                    this.border.draw(igd, this.borderWidth, 0, 0, s.width, s.height);
                    return;
                }
                if (layer != UILayer.Content) return;
                this.renderContents(black, igd);
                return;
            }
        } else if (layer == UILayer.Base) {
            this.border.draw(igd, this.borderWidth, 0, 0, s.width, s.height);
            return;
        } else {
            if (layer != UILayer.Content) return;
            this.renderContents(black, igd);
        }
    }

    @Override
    public final void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        peripherals.performOffset(this.contentsRelativeInputBounds.x, this.contentsRelativeInputBounds.y);
        this.updateContents(deltaTime, selected, peripherals);
        peripherals.performOffset(-this.contentsRelativeInputBounds.x, -this.contentsRelativeInputBounds.y);
    }

    public abstract void renderContents(boolean var1, IGrDriver var2);

    public abstract void updateContents(double var1, boolean var3, IPeripherals var4);

    public static boolean getBlackTextFlagWindowRoot(Theme theme) {
        return UIBorderedElement.getBlackTextFlag(theme, Theme.B_WINDOW);
    }

    public static boolean getMoveDownFlag(Theme theme, Theme.Attr<IBorder> borderType) {
        return UIBorderedElement.getBorderFlag2(theme, borderType, 1);
    }

    public static boolean getBlackTextFlag(Theme theme, Theme.Attr<IBorder> borderType) {
        return UIBorderedElement.getBorderFlag2(theme, borderType, 8);
    }

    private static boolean getBorderFlag2(Theme theme, Theme.Attr<IBorder> borderType, int flag) {
        return borderType.get(theme).getFlag(flag);
    }

    public static void drawBorder(Theme theme, IGrDriver igd, Theme.Attr<IBorder> borderType, int borderWidth, Rect where) {
        UIBorderedElement.drawBorder(theme, igd, borderType, borderWidth, where.x, where.y, where.width, where.height);
    }

    public static void drawBorder(Theme theme, IGrDriver igd, Theme.Attr<IBorder> borderType, int borderWidth, int x, int y, int w, int h) {
        borderType.get(theme).draw(igd, borderWidth, x, y, w, h);
    }
}

