/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.elements;

import gabien.ui.UIElement;
import gabien.ui.elements.UINumberBox;
import gabien.ui.elements.UITextButton;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;

public class UIAdjuster
extends UIElement.UIPanel
implements Consumer<String> {
    public final UITextButton incButton;
    public final UITextButton decButton;
    public final UINumberBox numberDisplay;

    public UIAdjuster(int h, long initial, Function<Long, Long> write) {
        super(h * 16, h);
        this.numberDisplay = new UINumberBox(initial, h);
        this.incButton = new UITextButton("+", h, () -> this.numberDisplay.setNumber((Long)write.apply(this.numberDisplay.getNumber() + 1L)));
        this.layoutAddElement(this.incButton);
        this.decButton = new UITextButton("-", h, () -> this.numberDisplay.setNumber((Long)write.apply(this.numberDisplay.getNumber() - 1L)));
        this.layoutAddElement(this.decButton);
        this.numberDisplay.onEdit = () -> this.numberDisplay.setNumber((Long)write.apply(this.numberDisplay.getNumber()));
        this.layoutAddElement(this.numberDisplay);
        this.forceToRecommended();
    }

    @Override
    protected void layoutRunImpl() {
        Size decButtonSize = this.decButton.getWantedSize();
        Size numberDisplaySize = this.numberDisplay.getWantedSize();
        Size incButtonSize = this.incButton.getWantedSize();
        int dbw = decButtonSize.width;
        int ibw = incButtonSize.width;
        Size m = this.getSize();
        this.decButton.setForcedBounds(this, new Rect(0, 0, dbw, decButtonSize.height));
        this.numberDisplay.setForcedBounds(this, new Rect(dbw, 0, m.width - (dbw + ibw), numberDisplaySize.height));
        this.incButton.setForcedBounds(this, new Rect(m.width - ibw, 0, ibw, incButtonSize.height));
    }

    @Override
    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        Size decButtonSize = this.decButton.getWantedSize();
        Size numberDisplaySize = this.numberDisplay.getWantedSize();
        Size incButtonSize = this.incButton.getWantedSize();
        return new Size(incButtonSize.width + numberDisplaySize.width + decButtonSize.width, Math.max(incButtonSize.height, Math.max(numberDisplaySize.height, decButtonSize.height)));
    }

    @Override
    public void accept(String a) {
        this.numberDisplay.setText(a);
    }

    @Override
    public void handleMousewheel(int x, int y, boolean north) {
        if (north) {
            this.incButton.onClick.run();
        } else {
            this.decButton.onClick.run();
        }
    }
}

