/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui.dialogs;

import gabien.GaBIEn;
import gabien.ui.UIElement;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UITextButton;
import gabien.ui.layouts.UIScrollLayout;
import gabien.ui.layouts.UISplitterLayout;
import gabien.uslx.append.Rect;
import gabien.uslx.licensing.LicenseComponent;
import gabien.uslx.licensing.LicenseManager;
import java.util.LinkedList;
import org.eclipse.jdt.annotation.Nullable;

public class UICredits
extends UIElement.UIProxy {
    private final UILabel labelHeader;
    private final UITextButton urlButton;
    private final UILabel labelLicense;
    private final UILabel labelCredits;
    @Nullable
    private String lastURL;

    public UICredits(int sc, int textHeight) {
        this.labelHeader = new UILabel("", textHeight);
        this.urlButton = new UITextButton("", textHeight, () -> {
            String url = this.lastURL;
            if (url != null) {
                GaBIEn.tryStartBrowser(url);
            }
        });
        UIScrollLayout buttons = new UIScrollLayout(true, sc);
        LinkedList<LicenseComponent> lcl = LicenseManager.I.getSortedLicenseComponents();
        LinkedList<UITextButton> elms = new LinkedList<UITextButton>();
        for (LicenseComponent lc : lcl) {
            elms.add(new UITextButton(lc.name, textHeight, () -> this.loadLicenseComponent(lc)));
        }
        buttons.panelsSet(elms);
        this.labelLicense = new UILabel("", textHeight);
        this.labelCredits = new UILabel("", textHeight);
        UIScrollLayout mainUSL = new UIScrollLayout(true, sc, this.labelHeader, this.urlButton, this.labelLicense, this.labelCredits);
        this.proxySetElement(new UISplitterLayout(new UILabel("Presence in this list does not imply endorsement by the involved parties.", textHeight), new UISplitterLayout(buttons, mainUSL, false, 0.0), true, 0.0), true);
        this.setForcedBounds(null, new Rect(0, 0, textHeight * 32, textHeight * 16));
        if (lcl.size() > 0) {
            this.loadLicenseComponent(lcl.getFirst());
        }
    }

    private void loadLicenseComponent(LicenseComponent lc) {
        String cf;
        this.labelHeader.setText(lc.name);
        this.urlButton.setText(lc.url);
        this.lastURL = lc.url;
        String lf = GaBIEn.getTextResourceAsString(lc.licenseFile);
        String creditsFn = lc.creditsFile;
        String string = cf = creditsFn != null ? GaBIEn.getTextResourceAsString(creditsFn) : "";
        if (lf == null) {
            lf = "<license file missing>";
        }
        if (cf == null) {
            cf = "<credits file missing>";
        }
        this.labelLicense.setText(lf);
        this.labelCredits.setText(cf);
    }
}

