/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui;

import gabien.GaBIEn;
import gabien.render.IGrDriver;
import gabien.ui.IPointerReceiver;
import gabien.ui.UIElement;
import gabien.ui.elements.UIBorderedElement;
import gabien.ui.theming.Theme;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IDesktopPeripherals;
import gabien.wsi.IGrInDriver;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import gabien.wsi.WindowSpecs;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.WeakHashMap;
import java.util.function.Consumer;

public class WindowCreatingUIElementConsumer
implements Consumer<UIElement> {
    private LinkedList<ActiveWindow> activeWindows = new LinkedList();
    private LinkedList<ActiveWindow> incomingWindows = new LinkedList();

    @Override
    public void accept(UIElement o) {
        this.accept(o, 1, false);
    }

    public void accept(UIElement o, int scale, boolean fullscreen) {
        this.accept(o, scale, fullscreen, true);
    }

    protected WindowSpecs setupSpecs(UIElement o, int scale, boolean fullscreen, boolean resizable) {
        Rect bounds = o.getParentRelativeBounds();
        WindowSpecs ws = GaBIEn.defaultWindowSpecs(o.toString(), bounds.width, bounds.height);
        ws.scale = scale;
        ws.resizable = resizable;
        ws.fullscreen = fullscreen;
        ws.backgroundLight = UIBorderedElement.getBlackTextFlagWindowRoot(o.getTheme());
        return ws;
    }

    public void accept(UIElement o, int scale, boolean fullscreen, boolean resizable) {
        ActiveWindow aw = new ActiveWindow();
        Rect bounds = o.getParentRelativeBounds();
        aw.igd = GaBIEn.makeGrIn(o.toString(), bounds.width, bounds.height, this.setupSpecs(o, scale, fullscreen, resizable));
        aw.peripherals = aw.igd.getPeripherals();
        aw.ue = o;
        this.incomingWindows.add(aw);
        o.setAttachedToRoot(true);
    }

    public LinkedList<UIElement> runningWindows() {
        LinkedList<UIElement> w = new LinkedList<UIElement>();
        for (ActiveWindow aw : this.activeWindows) {
            w.add(aw.ue);
        }
        for (ActiveWindow aw : this.incomingWindows) {
            w.add(aw.ue);
        }
        return w;
    }

    public int runningWindowCount() {
        return this.activeWindows.size() + this.incomingWindows.size();
    }

    public void runTick(double dT) {
        this.activeWindows.addAll(this.incomingWindows);
        this.incomingWindows.clear();
        LinkedList<ActiveWindow> closeTheseSD = new LinkedList<ActiveWindow>();
        LinkedList<ActiveWindow> closeTheseNS = new LinkedList<ActiveWindow>();
        for (ActiveWindow aw : new LinkedList<ActiveWindow>(this.activeWindows)) {
            IDesktopPeripherals idp;
            int ip;
            IPointerReceiver ipr;
            if (!aw.igd.stillRunning()) {
                aw.ue.setAttachedToRoot(false);
                closeTheseNS.add(aw);
                continue;
            }
            ++aw.nextBackBuffer;
            aw.nextBackBuffer %= aw.backBuffers.length;
            IGrDriver backbuffer = aw.backBuffers[aw.nextBackBuffer] = aw.igd.ensureBackBuffer(aw.backBuffers[aw.nextBackBuffer]);
            boolean needResize = false;
            int cw = aw.igd.getWidth();
            int ch = aw.igd.getHeight();
            Size s = aw.ue.getSize();
            if (s.width != cw) {
                needResize = true;
            }
            if (s.height != ch) {
                needResize = true;
            }
            if (needResize) {
                aw.ue.setForcedBounds(null, new Rect(0, 0, cw, ch));
            }
            backbuffer.clearAndCycleTransformAndScissorStacks();
            float[] trs = backbuffer.trs;
            trs[0] = 0.0f;
            trs[1] = 0.0f;
            trs[2] = 1.0f;
            trs[3] = 1.0f;
            int[] sti = backbuffer.scissor;
            sti[0] = 0;
            sti[1] = 0;
            sti[2] = cw;
            sti[3] = ch;
            aw.peripherals.clearOffset();
            UIBorderedElement.drawBorder(aw.ue.getTheme(), backbuffer, Theme.B_WINDOW, 0, 0, 0, cw, ch);
            aw.ue.update(dT, true, aw.peripherals);
            aw.ue.renderAllLayers(backbuffer);
            aw.peripherals.clearOffset();
            HashSet<IPointer> pointersNext = aw.peripherals.getActivePointers();
            for (IPointer ip2 : pointersNext) {
                if (!aw.lastActivePointers.contains(ip2)) {
                    ipr = aw.ue.handleNewPointer(ip2);
                    if (ipr == null) continue;
                    ipr.handlePointerBegin(ip2);
                    aw.receiverMap.put(ip2, ipr);
                    continue;
                }
                ipr = aw.receiverMap.get(ip2);
                if (ipr == null) continue;
                ipr.handlePointerUpdate(ip2);
            }
            for (IPointer ip2 : aw.lastActivePointers) {
                if (pointersNext.contains(ip2) || (ipr = aw.receiverMap.get(ip2)) == null) continue;
                ipr.handlePointerEnd(ip2);
                aw.receiverMap.remove(ip2);
            }
            aw.lastActivePointers = pointersNext;
            if (aw.peripherals instanceof IDesktopPeripherals && (ip = (idp = (IDesktopPeripherals)aw.peripherals).getMousewheelBuffer()) != 0) {
                aw.ue.handleMousewheel(idp.getMouseX(), idp.getMouseY(), ip == -1);
            }
            if (aw.igd.stillRunning()) {
                aw.igd.flush(backbuffer);
            }
            if (!aw.ue.requestsUnparenting()) continue;
            closeTheseSD.add(aw);
            aw.igd.shutdown();
            aw.ue.setAttachedToRoot(false);
        }
        this.activeWindows.removeAll(closeTheseSD);
        this.activeWindows.removeAll(closeTheseNS);
        for (ActiveWindow aw : closeTheseSD) {
            this.handleClosedUserWindow(aw.ue, true);
        }
        for (ActiveWindow aw : closeTheseNS) {
            this.handleClosedUserWindow(aw.ue, false);
        }
    }

    public void forceRemove(UIElement uie) {
        LinkedList<ActiveWindow> w = new LinkedList<ActiveWindow>();
        for (ActiveWindow aw : this.activeWindows) {
            if (aw.ue != uie) continue;
            w.add(aw);
        }
        for (ActiveWindow aw : this.incomingWindows) {
            if (aw.ue != uie) continue;
            w.add(aw);
        }
        for (ActiveWindow aw : w) {
            aw.ue.setAttachedToRoot(false);
            this.handleClosedUserWindow(aw.ue, false);
            this.activeWindows.remove(aw);
            this.incomingWindows.remove(aw);
            aw.igd.shutdown();
        }
    }

    public void handleClosedUserWindow(UIElement wvWindow, boolean selfDestruct) {
        wvWindow.onWindowClose();
    }

    private class ActiveWindow {
        IGrInDriver igd;
        int nextBackBuffer = 0;
        IGrDriver[] backBuffers = new IGrDriver[2];
        UIElement ue;
        IPeripherals peripherals;
        HashSet<IPointer> lastActivePointers = new HashSet();
        WeakHashMap<IPointer, IPointerReceiver> receiverMap = new WeakHashMap();

        private ActiveWindow() {
        }
    }
}

