/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui;

import datum.DatumSrcLoc;
import datum.DatumWriter;
import gabien.GaBIEnUI;
import gabien.render.IGrDriver;
import gabien.ui.IPointerReceiver;
import gabien.ui.LAFChain;
import gabien.ui.UILayer;
import gabien.uslx.append.Block;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import java.util.LinkedList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class UIElement
extends LAFChain {
    public static final UILayer[] LAYERS = new UILayer[]{UILayer.Clear, UILayer.Base, UILayer.Content};
    private Rect elementBounds = Rect.ZERO;
    @Nullable
    private UIElement parent;
    private Size wantedSize = Size.ZERO;
    private boolean wantedSizeIsOverride = false;
    private boolean visibleFlag = false;
    private boolean attachedToRootFlag;
    private boolean layoutingFlag;
    private boolean metrickingFlag;

    public UIElement() {
        this(GaBIEnUI.sysThemeRoot);
    }

    public UIElement(LAFChain.Node lafParent) {
        super(lafParent);
    }

    public UIElement(int width, int height) {
        this();
        Rect sz = new Rect(0, 0, width, height);
        this.wantedSize = sz;
        this.elementBounds = sz;
    }

    public final void setForcedBounds(UIElement mustBeThis, Rect r) {
        if (mustBeThis != this.parent) {
            throw new RuntimeException("You aren't allowed to do that, must be " + this.parent);
        }
        this.elementBounds = r;
        this.layoutRun();
    }

    public final void forceToRecommended() {
        this.layoutRecalculateMetrics();
        this.setForcedBounds(null, new Rect(this.getWantedSize()));
    }

    public final Rect getParentRelativeBounds() {
        if (this.metrickingFlag) {
            System.err.println("GaBIEnUI: WARNING: " + this + ".getParentRelativeBounds() called during metricking.");
        }
        return this.elementBounds;
    }

    public final Size getSize() {
        if (this.metrickingFlag) {
            System.err.println("GaBIEnUI: WARNING: " + this + ".getSize() called during metricking.");
        }
        return this.elementBounds;
    }

    public int layoutGetWForH(int height) {
        return this.getWantedSize().width;
    }

    public int layoutGetHForW(int width) {
        return this.getWantedSize().height;
    }

    public final Size getWantedSize() {
        return this.wantedSize;
    }

    public abstract void update(double var1, boolean var3, IPeripherals var4);

    public void renderLayer(IGrDriver igd, UILayer layer) {
    }

    public final void renderAllLayers(IGrDriver igd) {
        for (UILayer layer : LAYERS) {
            this.renderLayer(igd, layer);
        }
    }

    private final void layoutRun() {
        if (this.layoutingFlag) {
            System.err.println("GaBIEnUI: WARNING: Recursive layout attempted. ni li ike suli! >:( @ " + this);
            return;
        }
        this.layoutingFlag = true;
        this.layoutRunImpl();
        this.layoutingFlag = false;
    }

    protected void layoutRunImpl() {
    }

    @Nullable
    protected Size layoutRecalculateMetricsImpl() {
        return null;
    }

    public final void setWantedSizeOverride(@Nullable Size adj) {
        if (adj == null) {
            this.wantedSizeIsOverride = false;
            this.layoutRecalculateMetrics();
            return;
        }
        this.wantedSize = adj;
        this.wantedSizeIsOverride = true;
        if (this.parent != null) {
            this.parent.layoutRecalculateMetrics();
        } else {
            this.layoutRun();
        }
    }

    public final void setWantedSize(@NonNull Size adj) {
        if (!this.wantedSizeIsOverride) {
            this.wantedSize = adj;
        }
        if (this.parent != null) {
            this.parent.layoutRecalculateMetrics();
        } else {
            this.layoutRun();
        }
    }

    protected final void layoutRecalculateMetrics() {
        if (this.metrickingFlag) {
            System.err.println("GaBIEnUI: WARNING: Recursive metricking implementation found. ni li ike suli! >:( @ " + this);
            return;
        }
        this.metrickingFlag = true;
        Size adj = this.layoutRecalculateMetricsImpl();
        this.metrickingFlag = false;
        if (adj != null) {
            if (!this.wantedSizeIsOverride) {
                this.wantedSize = adj;
            }
            if (this.parent != null) {
                this.parent.layoutRecalculateMetrics();
            } else {
                this.layoutRun();
            }
        } else {
            this.layoutRun();
        }
    }

    public boolean requestsUnparenting() {
        return false;
    }

    public void onWindowClose() {
    }

    private void internalSetParent(UIElement newParent) {
        this.parent = newParent;
        if (newParent != null) {
            this.setAttachedToRoot(newParent.attachedToRootFlag);
        } else {
            this.setAttachedToRoot(false);
        }
    }

    public void setAttachedToRoot(boolean attached) {
        this.attachedToRootFlag = attached;
    }

    public final boolean getAttachedToRoot() {
        return this.attachedToRootFlag;
    }

    public void handleMousewheel(int x, int y, boolean north) {
    }

    public IPointerReceiver handleNewPointer(IPointer state) {
        return IPointerReceiver.NopPointerReceiver.I;
    }

    public static int sensibleCellDiv(int i, int sz) {
        if (i < 0) {
            i -= sz - 1;
        }
        return i / sz;
    }

    public static int sensibleCellMod(int i, int sz) {
        return i - UIElement.sensibleCellDiv(i, sz) * sz;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public final UIElement getParent() {
        return this.parent;
    }

    public void debugDumpUITree(DatumWriter writer) {
        int hfw;
        writer.visitId(this.getClass().getName(), DatumSrcLoc.NONE);
        writer.visitInt(this.elementBounds.x, DatumSrcLoc.NONE);
        writer.visitInt(this.elementBounds.y, DatumSrcLoc.NONE);
        writer.visitInt(this.elementBounds.width, DatumSrcLoc.NONE);
        writer.visitInt(this.elementBounds.height, DatumSrcLoc.NONE);
        writer.visitComment(this.toString());
        writer.visitInt(this.wantedSize.width, DatumSrcLoc.NONE);
        writer.visitInt(this.wantedSize.height, DatumSrcLoc.NONE);
        writer.visitBoolean(this.wantedSizeIsOverride, DatumSrcLoc.NONE);
        writer.visitComment("wantedSize");
        int wfh = this.layoutGetWForH(this.wantedSize.height);
        if (wfh != this.wantedSize.width) {
            writer.visitComment("inconsistent getWforH = " + wfh);
        }
        if ((hfw = this.layoutGetHForW(this.wantedSize.width)) != this.wantedSize.height) {
            writer.visitComment("inconsistent getHforW = " + hfw);
        }
        if ((wfh = this.layoutGetWForH(this.elementBounds.height)) != this.elementBounds.width) {
            writer.visitComment(this.elementBounds.width + " != getWforH(" + this.elementBounds.height + ") = " + wfh);
        }
        if ((hfw = this.layoutGetHForW(this.elementBounds.width)) != this.elementBounds.height) {
            writer.visitComment(this.elementBounds.height + " != getHforW(" + this.elementBounds.width + ") = " + hfw);
        }
    }

    public static class UIProxy
    extends UIElement {
        private UIElement currentElement;

        public UIProxy() {
        }

        public UIProxy(UIElement element, boolean wanted) {
            this.proxySetElement(element, wanted);
        }

        protected final void proxySetElement(UIElement element, boolean wanted) {
            if (this.currentElement != null) {
                throw new RuntimeException("Cannot ever add an element more than once to a proxy.");
            }
            if (element == null) {
                throw new RuntimeException("Cannot add null as the element of a proxy.");
            }
            this.currentElement = element;
            if (wanted) {
                this.currentElement.forceToRecommended();
            }
            this.currentElement.internalSetParent((UIElement)this);
            this.setForcedBounds(null, new Rect(wanted ? this.currentElement.getWantedSize() : element.getSize()));
            this.layoutRecalculateMetrics();
        }

        @Override
        public final int layoutGetHForW(int width) {
            return this.currentElement.layoutGetHForW(width);
        }

        @Override
        public final int layoutGetWForH(int height) {
            return this.currentElement.layoutGetWForH(height);
        }

        @Override
        @Nullable
        protected Size layoutRecalculateMetricsImpl() {
            return this.currentElement.getSize();
        }

        protected final UIElement proxyGetElement() {
            return this.currentElement;
        }

        @Override
        public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
            this.currentElement.update(deltaTime, selected, peripherals);
        }

        @Override
        public void renderLayer(IGrDriver igd, UILayer layer) {
            this.currentElement.renderLayer(igd, layer);
        }

        @Override
        public void setAttachedToRoot(boolean attached) {
            super.setAttachedToRoot(attached);
            this.currentElement.setAttachedToRoot(attached);
        }

        @Override
        protected void layoutRunImpl() {
            this.currentElement.setForcedBounds(this, new Rect(this.getSize()));
        }

        @Override
        public boolean requestsUnparenting() {
            return this.currentElement.requestsUnparenting();
        }

        @Override
        public void handleMousewheel(int x, int y, boolean north) {
            this.currentElement.handleMousewheel(x, y, north);
        }

        @Override
        public IPointerReceiver handleNewPointer(IPointer state) {
            return this.currentElement.handleNewPointer(state);
        }

        public void release() {
            if (this.currentElement.parent != this) {
                throw new RuntimeException("Cannot release twice.");
            }
            this.currentElement.internalSetParent(null);
        }

        @Override
        public void onWindowClose() {
            this.currentElement.onWindowClose();
        }

        @Override
        public void debugDumpUITree(DatumWriter writer) {
            super.debugDumpUITree(writer);
            writer.visitList(DatumSrcLoc.NONE);
            ++writer.indent;
            this.currentElement.debugDumpUITree(writer);
            --writer.indent;
            writer.visitEnd(DatumSrcLoc.NONE);
            writer.visitNewline();
        }
    }

    public static abstract class UIPanel
    extends UIElement {
        private static final boolean debugSelection = false;
        private UIElement selectedElement;
        private LinkedList<UIElement> allElements = new LinkedList();
        private UIElement[] cachedAllElements;
        private boolean allElementsChanged = true;
        private boolean released = false;
        private final boolean panelScissors;

        public UIPanel() {
            this(false);
        }

        public UIPanel(int w, int h) {
            this(false, w, h);
        }

        public UIPanel(boolean scissors) {
            this.panelScissors = scissors;
        }

        public UIPanel(boolean scissors, int w, int h) {
            super(w, h);
            this.panelScissors = scissors;
        }

        private void recacheElements() {
            if (this.allElementsChanged) {
                this.cachedAllElements = this.allElements.toArray(new UIElement[0]);
                this.allElementsChanged = false;
            }
        }

        protected final void layoutAddElement(UIElement uie) {
            if (uie.parent != null) {
                throw new RuntimeException("UIE " + uie + " already has parent " + uie.parent + " in " + this);
            }
            uie.internalSetParent((UIElement)this);
            uie.visibleFlag = true;
            this.allElements.add(uie);
            this.allElementsChanged = true;
        }

        protected final void layoutRemoveElement(UIElement uie) {
            if (uie.parent != this) {
                throw new RuntimeException("UIE " + uie + " already lost parent somehow in " + this);
            }
            uie.internalSetParent(null);
            if (this.selectedElement == uie) {
                this.selectedElement = null;
            }
            this.allElements.remove(uie);
            this.allElementsChanged = true;
        }

        protected final void layoutSetElementVis(UIElement uie, boolean visible) {
            if (uie.parent != this) {
                throw new RuntimeException("Can't set visibility of an element " + uie + " we don't have in " + this);
            }
            uie.visibleFlag = visible;
        }

        protected final boolean layoutContainsElement(UIElement uie) {
            return uie.parent == this;
        }

        protected final boolean layoutElementVisible(UIElement uie) {
            if (uie.parent != this) {
                throw new RuntimeException("Can't get visibility of an element " + uie + " we don't have in " + this);
            }
            return uie.visibleFlag;
        }

        protected final void layoutSelect(UIElement uie) {
            if (uie != null && uie.parent != this) {
                throw new RuntimeException("Can't select something " + uie + " we " + this + " don't have.");
            }
            this.selectedElement = uie;
        }

        protected final LinkedList<UIElement> layoutGetElements() {
            return new LinkedList<UIElement>(this.allElements);
        }

        protected final Iterable<UIElement> layoutGetElementsIterable() {
            return this.allElements;
        }

        protected final int layoutGetElementsCount() {
            return this.allElements.size();
        }

        @Override
        public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
            if (this.released) {
                throw new RuntimeException("Trying to use released panel.");
            }
            this.recacheElements();
            for (UIElement uie : this.cachedAllElements) {
                int x = ((UIElement)uie).elementBounds.x;
                int y = ((UIElement)uie).elementBounds.y;
                peripherals.performOffset(-x, -y);
                uie.update(deltaTime, selected && this.selectedElement == uie, peripherals);
                peripherals.performOffset(x, y);
            }
        }

        @Override
        public void renderLayer(IGrDriver igd, UILayer layer) {
            if (this.released) {
                throw new RuntimeException("Trying to use released panel.");
            }
            this.recacheElements();
            if (this.panelScissors) {
                for (UIElement uie : this.cachedAllElements) {
                    if (!uie.visibleFlag) continue;
                    UIPanel.unscissoredRender(uie, igd, layer);
                }
            } else {
                for (UIElement uie : this.cachedAllElements) {
                    if (!uie.visibleFlag) continue;
                    UIPanel.scissoredRender(uie, igd, layer);
                }
            }
        }

        @Override
        public void setAttachedToRoot(boolean attached) {
            super.setAttachedToRoot(attached);
            this.recacheElements();
            for (UIElement uie : this.cachedAllElements) {
                uie.setAttachedToRoot(attached);
            }
        }

        public static void unscissoredRender(UIElement uie, IGrDriver igd, UILayer layer) {
            int x = ((UIElement)uie).elementBounds.x;
            int y = ((UIElement)uie).elementBounds.y;
            float[] trs = igd.trs;
            float osTX = trs[0];
            float osTY = trs[1];
            trs[0] = trs[0] + (float)x;
            trs[1] = trs[1] + (float)y;
            uie.renderLayer(igd, layer);
            trs[0] = osTX;
            trs[1] = osTY;
        }

        public static void scissoredRender(UIElement uie, IGrDriver igd, UILayer layer) {
            int x = ((UIElement)uie).elementBounds.x;
            int y = ((UIElement)uie).elementBounds.y;
            float[] trs = igd.trs;
            float osTX = trs[0];
            float osTY = trs[1];
            float osSX = trs[2];
            float osSY = trs[3];
            try (Block b = igd.openScissor(x, y, ((UIElement)uie).elementBounds.width, ((UIElement)uie).elementBounds.height);){
                float scaledX = (float)x * osSX;
                float scaledY = (float)y * osSY;
                trs[0] = trs[0] + scaledX;
                trs[1] = trs[1] + scaledY;
                uie.renderLayer(igd, layer);
                trs[0] = osTX;
                trs[1] = osTY;
            }
        }

        @Override
        protected abstract void layoutRunImpl();

        @Override
        public void handleMousewheel(int x, int y, boolean north) {
            this.recacheElements();
            for (UIElement uie : this.cachedAllElements) {
                Rect r = uie.elementBounds;
                if (!r.contains(x, y)) continue;
                uie.handleMousewheel(x - r.x, y - r.y, north);
                return;
            }
        }

        @Override
        public IPointerReceiver handleNewPointer(IPointer state) {
            this.selectedElement = null;
            this.recacheElements();
            for (UIElement uie : this.cachedAllElements) {
                if (!uie.visibleFlag || !uie.elementBounds.contains(state.getX(), state.getY())) continue;
                int x = ((UIElement)uie).elementBounds.x;
                int y = ((UIElement)uie).elementBounds.y;
                state.performOffset(-x, -y);
                IPointerReceiver ipr = uie.handleNewPointer(state);
                state.performOffset(x, y);
                if (ipr == null) continue;
                this.selectedElement = uie;
                return new IPointerReceiver.TransformingElementPointerReceiver(this.selectedElement, ipr);
            }
            return null;
        }

        public void release() {
            for (UIElement uie : this.allElements) {
                uie.internalSetParent(null);
            }
            this.allElements.clear();
            this.allElementsChanged = true;
            this.released = true;
        }

        @Override
        public void debugDumpUITree(DatumWriter writer) {
            super.debugDumpUITree(writer);
            for (UIElement uie : this.cachedAllElements) {
                writer.visitList(DatumSrcLoc.NONE);
                ++writer.indent;
                uie.debugDumpUITree(writer);
                --writer.indent;
                writer.visitEnd(DatumSrcLoc.NONE);
                writer.visitNewline();
            }
        }
    }
}

