/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui;

import gabien.ui.IPointerReceiver;
import gabien.wsi.IPointer;

public class OldMouseEmulator
implements IPointerReceiver {
    public final IOldMouseReceiver receiver;
    public IPointer pointer = null;
    public int mouseX;
    public int mouseY;

    public OldMouseEmulator(IOldMouseReceiver r) {
        this.receiver = r;
    }

    @Override
    public void handlePointerBegin(IPointer state) {
        if (this.pointer != null) {
            this.receiver.handleRelease(this.pointer.getX(), this.pointer.getY());
        }
        this.pointer = state;
        this.mouseX = state.getX();
        this.mouseY = state.getY();
        IPointer.PointerType pt = this.pointer.getType();
        int button = 0;
        if (pt == IPointer.PointerType.Generic) {
            button = 1;
        }
        if (pt == IPointer.PointerType.Middle) {
            button = 2;
        }
        if (pt == IPointer.PointerType.Right) {
            button = 3;
        }
        if (pt == IPointer.PointerType.X1) {
            button = 4;
        }
        if (pt == IPointer.PointerType.X2) {
            button = 5;
        }
        this.receiver.handleClick(this.pointer.getX(), this.pointer.getY(), button);
    }

    @Override
    public void handlePointerUpdate(IPointer state) {
        if (this.pointer == state) {
            this.mouseX = state.getX();
            this.mouseY = state.getY();
            this.receiver.handleDrag(state.getX(), state.getY());
        }
    }

    @Override
    public void handlePointerEnd(IPointer state) {
        if (this.pointer == state) {
            this.mouseX = state.getX();
            this.mouseY = state.getY();
            this.receiver.handleRelease(state.getX(), state.getY());
            this.pointer = null;
        }
    }

    public static interface IOldMouseReceiver {
        public void handleClick(int var1, int var2, int var3);

        public void handleDrag(int var1, int var2);

        public void handleRelease(int var1, int var2);
    }
}

