/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui;

import gabien.ui.theming.Theme;
import gabien.uslx.append.RefSyncSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class LAFChain {
    @Nullable
    private Node lafParent;
    private RefSyncSet.Holder lafParentHolder;
    @NonNull
    private Theme theme = Theme.ROOT;
    @Nullable
    private Theme themeOverride = null;

    LAFChain() {
    }

    LAFChain(Node lafParent) {
        this.lafParent = lafParent;
        if (lafParent != null) {
            this.lafParentHolder = lafParent.children.addWeak(this);
        }
        this.theme = this.calculateTheme();
    }

    @Nullable
    public final LAFChain getLAFParent() {
        return this.lafParent;
    }

    public void setLAFParent(@Nullable Node parent) {
        if (this.lafParentHolder != null) {
            this.lafParent.children.remove(this.lafParentHolder);
            this.lafParentHolder = null;
        }
        this.lafParent = parent;
        if (this.lafParent != null) {
            this.lafParentHolder = this.lafParent.children.addWeak(this);
        }
        this.themeUpdate();
    }

    @NonNull
    public final Theme getTheme() {
        return this.theme;
    }

    @Nullable
    public final Theme getThemeOverride() {
        return this.themeOverride;
    }

    public final void setThemeOverride(@Nullable Theme themeOverride) {
        this.themeOverride = themeOverride;
        this.themeUpdate();
    }

    @NonNull
    private final Theme calculateTheme() {
        Theme override = this.themeOverride;
        Node parent = this.lafParent;
        if (override != null) {
            return override;
        }
        if (parent != null) {
            return parent.theme;
        }
        return Theme.ROOT;
    }

    private final void themeUpdate() {
        Theme newTheme = this.calculateTheme();
        if (newTheme != this.theme) {
            this.theme = newTheme;
            this.onThemeChanged();
            this.themeUpdateChildren();
        }
    }

    void themeUpdateChildren() {
    }

    public void onThemeChanged() {
    }

    public static final class Node
    extends LAFChain {
        private RefSyncSet<LAFChain> children = new RefSyncSet();

        @Override
        void themeUpdateChildren() {
            for (LAFChain chain : this.children) {
                chain.themeUpdate();
            }
        }
    }
}

