/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui;

import gabien.ui.UIElement;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IPointer;
import java.util.function.Consumer;

public interface IPointerReceiver {
    public void handlePointerBegin(IPointer var1);

    public void handlePointerUpdate(IPointer var1);

    public void handlePointerEnd(IPointer var1);

    public static class RelativeResizePointerReceiver
    implements IPointerReceiver {
        public final Size firstSize;
        public int xSt;
        public int ySt;
        public final Consumer<Size> consumer;
        public Size lastSize;

        public RelativeResizePointerReceiver(int w, int h, Consumer<Size> iConsumer) {
            this.lastSize = this.firstSize = new Size(w, h);
            this.consumer = iConsumer;
        }

        @Override
        public void handlePointerBegin(IPointer state) {
            this.xSt = state.getX();
            this.ySt = state.getY();
        }

        @Override
        public void handlePointerUpdate(IPointer state) {
            this.lastSize = new Size(state.getX() - this.xSt + this.firstSize.width, state.getY() - this.ySt + this.firstSize.height);
            this.consumer.accept(this.lastSize);
        }

        @Override
        public void handlePointerEnd(IPointer state) {
            this.handlePointerUpdate(state);
        }
    }

    public static class TransformingElementPointerReceiver
    implements IPointerReceiver {
        public final UIElement element;
        public final IPointerReceiver ipr;

        public TransformingElementPointerReceiver(UIElement uie, IPointerReceiver i) {
            this.element = uie;
            this.ipr = i;
        }

        @Override
        public void handlePointerBegin(IPointer state) {
            Rect r = this.element.getParentRelativeBounds();
            state.performOffset(-r.x, -r.y);
            this.ipr.handlePointerBegin(state);
            state.performOffset(r.x, r.y);
        }

        @Override
        public void handlePointerUpdate(IPointer state) {
            Rect r = this.element.getParentRelativeBounds();
            state.performOffset(-r.x, -r.y);
            this.ipr.handlePointerUpdate(state);
            state.performOffset(r.x, r.y);
        }

        @Override
        public void handlePointerEnd(IPointer state) {
            Rect r = this.element.getParentRelativeBounds();
            state.performOffset(-r.x, -r.y);
            this.ipr.handlePointerEnd(state);
            state.performOffset(r.x, r.y);
        }
    }

    public static enum NopPointerReceiver implements IPointerReceiver
    {
        I;


        @Override
        public void handlePointerBegin(IPointer state) {
        }

        @Override
        public void handlePointerUpdate(IPointer state) {
        }

        @Override
        public void handlePointerEnd(IPointer state) {
        }
    }
}

