/*
 * Decompiled with CFR 0.152.
 */
package gabien.ui;

import gabien.GaBIEn;
import gabien.text.IFixedSizeFont;
import gabien.text.TextTools;
import gabien.uslx.append.Size;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class FontManager {
    public final String fontOverride;
    public final boolean fontOverrideUE8;
    private ReentrantLock formatLock = new ReentrantLock();
    private WeakHashMap<String, String> formatData = new WeakHashMap();

    public FontManager(String fo, boolean ue8) {
        this.fontOverride = fo;
        this.fontOverrideUE8 = ue8;
    }

    private boolean useSystemFont(String text, int height) {
        if (this.fontOverride != null) {
            if (height > 8) {
                return true;
            }
            if (this.fontOverrideUE8) {
                return true;
            }
        }
        if (height != 16 && height != 8 && height != 6) {
            return true;
        }
        int l = text.length();
        for (int p = 0; p < l; ++p) {
            if (text.charAt(p) < '\u0080') continue;
            return true;
        }
        return false;
    }

    public IFixedSizeFont getFontForText(String text, int height) {
        return this.getFontForText(text, height, 0);
    }

    public IFixedSizeFont getFontForText(String text, int height, int style) {
        if (this.useSystemFont(text, height)) {
            return GaBIEn.getNativeFont(height, this.fontOverride, true);
        }
        return GaBIEn.engineFonts.derive(height, style);
    }

    public Size getTextSize(String text, int textHeight) {
        int lineContentHeight;
        int w = 0;
        IFixedSizeFont font = this.getFontForText(text, textHeight);
        int h = lineContentHeight = font.getContentHeight();
        while (text.length() > 0) {
            int nlI = text.indexOf(10);
            String tLine = text;
            if (nlI != -1) {
                tLine = tLine.substring(0, nlI);
                text = text.substring(nlI + 1);
                h += textHeight;
            } else {
                text = "";
            }
            w = Math.max(w, font.measureLine(tLine, false));
        }
        return new Size(w, h);
    }

    public int getFontSizeGeneralContentHeight(int textHeight) {
        return this.getFontForText("", textHeight).getContentHeight();
    }

    public int getLineLength(String text, int height) {
        return this.getFontForText(text, height).measureLine(text, false);
    }

    public String formatTextFor(String text, int textHeight, int width) {
        if (width <= 0) {
            return "";
        }
        String key = width + ";" + textHeight + ";" + text;
        this.formatLock.lock();
        String res = this.formatData.get(key);
        this.formatLock.unlock();
        if (res != null) {
            return res;
        }
        IFixedSizeFont font = this.getFontForText(text, textHeight);
        res = TextTools.formatTextFor(text, font, width);
        this.formatLock.lock();
        this.formatData.put(key, res);
        this.formatLock.unlock();
        return res;
    }
}

