/*
 * Decompiled with CFR 0.152.
 */
package gabien.text;

import gabien.text.IFixedSizeFont;
import gabien.text.RenderedTextChunk;
import java.util.LinkedList;

public class TextTools {
    public static RenderedTextChunk renderString(String text, IFixedSizeFont font, boolean textBlack) {
        int r = textBlack ? 0 : 255;
        return TextTools.renderString(text, font, r, r, r, 255);
    }

    public static RenderedTextChunk renderString(String text, IFixedSizeFont font, int r, int g, int b, int a) {
        char[] textArray = text.toCharArray();
        int textStart = 0;
        int textPtr = 0;
        LinkedList<RenderedTextChunk> chunks = new LinkedList<RenderedTextChunk>();
        while (true) {
            if (textPtr == textArray.length || textArray[textPtr] == '\n') {
                chunks.add(font.renderLine(textArray, textStart, textPtr - textStart, r, g, b, a));
                if (textPtr == textArray.length) break;
                chunks.add(RenderedTextChunk.CRLF.INSTANCE);
                textStart = textPtr + 1;
            }
            ++textPtr;
        }
        return new RenderedTextChunk.Compound(chunks.toArray(new RenderedTextChunk[0]));
    }

    public static String formatTextFor(String text, IFixedSizeFont font, int width) {
        if (width <= 0) {
            return "";
        }
        String[] newlines = text.split("\n", -1);
        StringBuilder work = new StringBuilder();
        if (newlines.length == 1) {
            String firstLine = newlines[0];
            while (true) {
                boolean testLen;
                String nextFirstLine = "";
                boolean bl = testLen = font.measureLine(firstLine, false) > width;
                if (testLen) {
                    int space;
                    while ((space = firstLine.lastIndexOf(32)) > 0 && testLen) {
                        nextFirstLine = firstLine.substring(space) + nextFirstLine;
                        testLen = font.measureLine(firstLine = firstLine.substring(0, space), false) > width;
                    }
                    while (testLen && firstLine.length() > 1) {
                        int split = firstLine.length() / 2;
                        nextFirstLine = firstLine.substring(split) + nextFirstLine;
                        testLen = font.measureLine(firstLine = firstLine.substring(0, split), false) > width;
                    }
                }
                work.append(firstLine);
                firstLine = nextFirstLine;
                if (firstLine.length() > 0) {
                    work.append("\n");
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < newlines.length; ++i) {
                if (i != 0) {
                    work.append('\n');
                }
                work.append(TextTools.formatTextFor(newlines[i], font, width));
            }
        }
        return work.toString();
    }

    public static class PlainCached {
        private IFixedSizeFont lastFont;
        private boolean lastBlackText;
        private String lastText;
        private boolean wasInitialized;
        public IFixedSizeFont font;
        public boolean blackText;
        public String text;
        private RenderedTextChunk lastChunk;

        public boolean shouldRender() {
            if (!this.wasInitialized) {
                return true;
            }
            if (this.lastFont != this.font) {
                return true;
            }
            if (this.lastBlackText != this.blackText) {
                return true;
            }
            return !this.lastText.equals(this.text);
        }

        public final void update() {
            if (this.shouldRender()) {
                this.forceRender();
            }
        }

        public void forceRender() {
            this.wasInitialized = true;
            this.lastFont = this.font;
            this.lastBlackText = this.blackText;
            this.lastText = this.text;
            this.lastChunk = TextTools.renderString(this.lastText, this.font, this.lastBlackText);
        }

        public final RenderedTextChunk getChunk() {
            return this.lastChunk;
        }
    }
}

