/*
 * Decompiled with CFR 0.152.
 */
package gabien.text;

import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.text.IImmFixedSizeFont;
import gabien.text.ImageRenderedTextChunk;
import org.eclipse.jdt.annotation.NonNull;

public class SimpleImageGridFont
implements IImmFixedSizeFont {
    public final IImage fontWhite;
    public final int charWidth;
    public final int charHeight;
    public final int charsPerRow;
    public final int advance;
    public final int size;

    public SimpleImageGridFont(IImage base, int charWidth, int charHeight, int charsPerRow, int advance, int size) {
        this.fontWhite = base;
        this.charWidth = charWidth;
        this.charHeight = charHeight;
        this.charsPerRow = charsPerRow;
        this.advance = advance;
        this.size = size;
    }

    @Override
    public int getLineHeight() {
        return this.size;
    }

    @Override
    public int getContentHeight() {
        return this.charHeight;
    }

    @Override
    public int measureLine(@NonNull String text, boolean withLastAdvance) {
        return SimpleImageGridFont.measureLineCommon(this.advance, this.charWidth, text.length(), withLastAdvance);
    }

    @Override
    public int measureLine(@NonNull char[] text, int index, int length, boolean withLastAdvance) {
        return SimpleImageGridFont.measureLineCommon(this.advance, this.charWidth, length, withLastAdvance);
    }

    public static int measureLineCommon(int advance, int charWidth, int length, boolean withLastAdvance) {
        if (withLastAdvance) {
            return length * advance;
        }
        if (length == 0) {
            return 0;
        }
        return (length - 1) * advance + charWidth;
    }

    @Override
    public void drawLine(@NonNull IGrDriver igd, int x, int y, @NonNull char[] text, int index, int length, int r, int g, int b, int a) {
        y -= this.charHeight;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float af = (float)a / 255.0f;
        int lim = index + length;
        for (int p = index; p < lim; ++p) {
            char cc = text[p];
            if (cc < '\u0100') {
                igd.drawScaledColoured(cc % this.charsPerRow * this.charWidth, cc / this.charsPerRow * this.charHeight, this.charWidth, this.charHeight, x, y, this.charWidth, this.charHeight, this.fontWhite, rf, gf, bf, af);
            } else {
                igd.drawScaledColoured(0.0f, 0.0f, this.charWidth, this.charHeight, x, y, this.charWidth, this.charHeight, this.fontWhite, rf, gf, bf, af);
            }
            x += this.advance;
        }
    }

    @Override
    public void drawLine(@NonNull IGrDriver igd, int x, int y, @NonNull String text, int r, int g, int b, int a) {
        y -= this.charHeight;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float af = (float)a / 255.0f;
        int length = text.length();
        for (int p = 0; p < length; ++p) {
            char cc = text.charAt(p);
            if (cc < '\u0100') {
                igd.drawScaledColoured(cc % this.charsPerRow * this.charWidth, cc / this.charsPerRow * this.charHeight, this.charWidth, this.charHeight, x, y, this.charWidth, this.charHeight, this.fontWhite, rf, gf, bf, af);
            } else {
                igd.drawScaledColoured(0.0f, 0.0f, this.charWidth, this.charHeight, x, y, this.charWidth, this.charHeight, this.fontWhite, rf, gf, bf, af);
            }
            x += this.advance;
        }
    }

    @Override
    public void drawBackground(IGrDriver igd, int x, int y, @NonNull char[] text, int index, int length, int r, int g, int b, int a) {
        this.drawBackgroundCommon(igd, x, y, length, r, g, b, a);
    }

    @Override
    public void drawBackground(IGrDriver igd, int x, int y, @NonNull String text, int r, int g, int b, int a) {
        this.drawBackgroundCommon(igd, x, y, text.length(), r, g, b, a);
    }

    private void drawBackgroundCommon(IGrDriver igd, int x, int y, int length, int r, int g, int b, int a) {
        ImageRenderedTextChunk.background(igd, x, y -= this.charHeight, SimpleImageGridFont.measureLineCommon(this.advance, this.charWidth, length, false), this.charHeight, 1, r, g, b, a);
    }
}

