/*
 * Decompiled with CFR 0.152.
 */
package gabien.text;

import gabien.render.IGrDriver;

public abstract class RenderedTextChunk {
    public final int highestLineHeight;
    public final int highestAscent;
    public final int highestDescent;
    public final int autoOffset;

    public RenderedTextChunk(int hlh, int asc, int dsc) {
        this.highestLineHeight = hlh;
        this.highestAscent = asc;
        this.highestDescent = dsc;
        this.autoOffset = asc + (hlh - (asc + dsc + 2)) / 2;
    }

    public abstract int cursorX(int var1);

    public abstract int cursorY(int var1, int var2);

    public final void renderTo(IGrDriver igd, int x, int y, int cursorXIn, int cursorYIn, int highestLineHeightIn) {
        this.renderTo(igd, x, y, cursorXIn, cursorYIn, highestLineHeightIn, 255, 255, 255, 255);
    }

    public abstract void renderTo(IGrDriver var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public abstract void backgroundTo(IGrDriver var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void debugTo(IGrDriver igd, int x, int y, int cursorXIn, int cursorYIn, int highestLineHeightIn) {
        int w = this.cursorX(cursorXIn) - cursorXIn;
        igd.fillRect(255, 0, 0, 128, x + cursorXIn, y + cursorYIn - this.highestAscent, w, this.highestAscent);
        igd.fillRect(0, 255, 0, 128, x + cursorXIn, y + cursorYIn, w, this.highestDescent);
        igd.fillRect(0, 0, 0, 128, x + cursorXIn, y + cursorYIn - this.highestAscent, 1.0f, this.highestAscent + this.highestDescent);
        igd.fillRect(0, 0, 0, 128, x + cursorXIn + w - 1, y + cursorYIn - this.highestAscent, 1.0f, this.highestAscent + this.highestDescent);
    }

    public final void renderRootAutoOffset(IGrDriver igd, int x, int y) {
        this.renderRootAutoOffset(igd, x, y, 255, 255, 255, 255);
    }

    public final void renderRoot(IGrDriver igd, int x, int y) {
        this.renderRoot(igd, x, y, 255, 255, 255, 255);
    }

    public final void renderRootAutoOffset(IGrDriver igd, int x, int y, int r, int g, int b, int a) {
        this.renderRoot(igd, x, y + this.autoOffset, r, g, b, a);
    }

    public final void renderRoot(IGrDriver igd, int x, int y, int r, int g, int b, int a) {
        this.renderTo(igd, x, y, 0, 0, this.highestLineHeight, r, g, b, a);
    }

    public final void debugRoot(IGrDriver igd, int x, int y) {
        this.debugTo(igd, x, y, 0, 0, this.highestLineHeight);
    }

    public void backgroundRootAutoOffset(IGrDriver igd, int x, int y, int r, int g, int b, int a) {
        this.backgroundRoot(igd, x, y + this.autoOffset, r, g, b, a);
    }

    public void backgroundRoot(IGrDriver igd, int x, int y, int r, int g, int b, int a) {
        this.backgroundTo(igd, x, y, 0, 0, this.highestLineHeight, r, g, b, a);
    }

    public static class Compound
    extends RenderedTextChunk {
        private final RenderedTextChunk[] components;

        private static int maxHLH(RenderedTextChunk[] c) {
            int hlh = 0;
            int n = 0;
            RenderedTextChunk[] renderedTextChunkArray = c;
            int n2 = renderedTextChunkArray.length;
            if (n < n2) {
                RenderedTextChunk rtc = renderedTextChunkArray[n];
                if (rtc.highestLineHeight > hlh) {
                    hlh = rtc.highestLineHeight;
                }
                return hlh;
            }
            return hlh;
        }

        private static int maxASC(RenderedTextChunk[] c) {
            int hlh = 0;
            int n = 0;
            RenderedTextChunk[] renderedTextChunkArray = c;
            int n2 = renderedTextChunkArray.length;
            if (n < n2) {
                RenderedTextChunk rtc = renderedTextChunkArray[n];
                if (rtc.highestAscent > hlh) {
                    hlh = rtc.highestAscent;
                }
                return hlh;
            }
            return hlh;
        }

        private static int maxDSC(RenderedTextChunk[] c) {
            int hlh = 0;
            int n = 0;
            RenderedTextChunk[] renderedTextChunkArray = c;
            int n2 = renderedTextChunkArray.length;
            if (n < n2) {
                RenderedTextChunk rtc = renderedTextChunkArray[n];
                if (rtc.highestDescent > hlh) {
                    hlh = rtc.highestDescent;
                }
                return hlh;
            }
            return hlh;
        }

        public Compound(RenderedTextChunk ... chunks) {
            super(Compound.maxHLH(chunks), Compound.maxASC(chunks), Compound.maxDSC(chunks));
            this.components = chunks;
        }

        @Override
        public int cursorX(int cursorXIn) {
            for (RenderedTextChunk rtc : this.components) {
                cursorXIn = rtc.cursorX(cursorXIn);
            }
            return cursorXIn;
        }

        @Override
        public int cursorY(int cursorYIn, int highestLineHeightIn) {
            for (RenderedTextChunk rtc : this.components) {
                cursorYIn = rtc.cursorY(cursorYIn, highestLineHeightIn);
            }
            return cursorYIn;
        }

        @Override
        public void renderTo(IGrDriver igd, int x, int y, int cursorXIn, int cursorYIn, int highestLineHeightIn, int r, int g, int b, int a) {
            for (RenderedTextChunk rtc : this.components) {
                rtc.renderTo(igd, x, y, cursorXIn, cursorYIn, highestLineHeightIn, r, g, b, a);
                cursorXIn = rtc.cursorX(cursorXIn);
                cursorYIn = rtc.cursorY(cursorYIn, highestLineHeightIn);
            }
        }

        @Override
        public void backgroundTo(IGrDriver igd, int x, int y, int cursorXIn, int cursorYIn, int highestLineHeightIn, int r, int g, int b, int a) {
            for (RenderedTextChunk rtc : this.components) {
                rtc.backgroundTo(igd, x, y, cursorXIn, cursorYIn, highestLineHeightIn, r, g, b, a);
                cursorXIn = rtc.cursorX(cursorXIn);
                cursorYIn = rtc.cursorY(cursorYIn, highestLineHeightIn);
            }
        }

        @Override
        public void debugTo(IGrDriver igd, int x, int y, int cursorXIn, int cursorYIn, int highestLineHeightIn) {
            for (RenderedTextChunk rtc : this.components) {
                rtc.debugTo(igd, x, y, cursorXIn, cursorYIn, highestLineHeightIn);
                cursorXIn = rtc.cursorX(cursorXIn);
                cursorYIn = rtc.cursorY(cursorYIn, highestLineHeightIn);
            }
        }
    }

    public static class CRLF
    extends RenderedTextChunk {
        public static final CRLF INSTANCE = new CRLF();

        private CRLF() {
            super(0, 0, 0);
        }

        @Override
        public int cursorX(int cursorXIn) {
            return 0;
        }

        @Override
        public int cursorY(int cursorYIn, int lineHeight) {
            return cursorYIn + lineHeight;
        }

        @Override
        public void renderTo(IGrDriver igd, int x, int y, int cursorXIn, int cursorYIn, int highestLineHeightIn, int r, int g, int b, int a) {
        }

        @Override
        public void backgroundTo(IGrDriver igd, int x, int y, int cursorXIn, int cursorYIn, int highestLineHeightIn, int r, int g, int b, int a) {
        }
    }
}

