/*
 * Decompiled with CFR 0.152.
 */
package gabien.text;

import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.render.ITexRegion;
import gabien.render.WSIImage;
import gabien.text.RenderedTextChunk;

public abstract class ImageRenderedTextChunk
extends RenderedTextChunk {
    public final int offsetX;
    public final int offsetY;
    public final int measureX;

    public ImageRenderedTextChunk(int offsetX, int offsetY, int measureX, int lineHeight, int ascent, int descent) {
        super(lineHeight, ascent, descent);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.measureX = measureX;
    }

    public abstract ITexRegion getIImage();

    public abstract WSIImage getIWSIImage();

    @Override
    public int cursorX(int cursorXIn) {
        return cursorXIn + this.measureX;
    }

    @Override
    public int cursorY(int cursorYIn, int lineHeight) {
        return cursorYIn;
    }

    @Override
    public void renderTo(IGrDriver igd, int x, int y, int cX, int cY, int hlh, int r, int g, int b, int a) {
        ITexRegion res = this.getIImage();
        x = x + cX + this.offsetX;
        y = y + cY + this.offsetY;
        float w = res.getRegionWidth();
        float h = res.getRegionHeight();
        igd.drawScaledColoured(0.0f, 0.0f, w, h, x, y, w, h, res, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public static void background(IGrDriver igd, int x, int y, int w, int h, int margin, int r, int g, int b, int a) {
        int margin2 = margin * 2;
        igd.fillRect(r, g, b, a, x - margin, y - margin, w + margin2, h + margin2);
    }

    @Override
    public void backgroundTo(IGrDriver igd, int x, int y, int cursorXIn, int cursorYIn, int highestLineHeightIn, int r, int g, int b, int a) {
        ImageRenderedTextChunk.background(igd, x + cursorXIn, y + cursorYIn, this.measureX, this.highestLineHeight, 1, r, g, b, a);
    }

    public static class GPU
    extends ImageRenderedTextChunk {
        public final IImage render;
        private WSIImage renderDownload;

        public GPU(int offsetX, int offsetY, int measureX, int lineHeight, int ascent, int descent, IImage r) {
            super(offsetX, offsetY, measureX, lineHeight, ascent, descent);
            this.render = r;
        }

        @Override
        public IImage getIImage() {
            return this.render;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WSIImage getIWSIImage() {
            GPU gPU = this;
            synchronized (gPU) {
                if (this.renderDownload == null) {
                    this.renderDownload = this.render.download();
                }
                return this.renderDownload;
            }
        }
    }

    public static class WSI
    extends ImageRenderedTextChunk {
        public final WSIImage render;
        private IImage renderUpload;

        public WSI(int offsetX, int offsetY, int measureX, int lineHeight, int ascent, int descent, WSIImage r) {
            super(offsetX, offsetY, measureX, lineHeight, ascent, descent);
            this.render = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImage getIImage() {
            WSI wSI = this;
            synchronized (wSI) {
                if (this.renderUpload == null) {
                    this.renderUpload = this.render.upload("Text");
                }
                return this.renderUpload;
            }
        }

        @Override
        public WSIImage getIWSIImage() {
            return this.render;
        }
    }
}

