/*
 * Decompiled with CFR 0.152.
 */
package gabien.text;

import gabien.GaBIEn;
import gabien.backend.IGaBIEn;
import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.text.IFixedSizeFont;
import gabien.text.ITypeface;
import gabien.text.ImageRenderedTextChunk;
import gabien.text.SimpleImageGridFont;
import org.eclipse.jdt.annotation.NonNull;

public final class EngineFonts
implements ITypeface {
    public final SimpleImageGridFont f6;
    public final SimpleImageGridFont f8;
    public final SimpleImageGridFont f16;

    public EngineFonts(IGaBIEn backend) {
        GaBIEn.verify(backend);
        IImage i6 = GaBIEn.getImageCKEx("fonttiny.png", false, true, 0, 0, 0);
        IImage i8 = GaBIEn.getImageCKEx("font.png", false, true, 0, 0, 0);
        IImage i16 = GaBIEn.getImageCKEx("font2x.png", false, true, 0, 0, 0);
        this.f6 = new SimpleImageGridFont(i6, 3, 5, 16, 4, 6);
        this.f8 = new SimpleImageGridFont(i8, 7, 7, 16, 8, 8);
        this.f16 = new SimpleImageGridFont(i16, 7, 14, 16, 8, 16);
    }

    public void drawString(IGrDriver igd, int x, int y, String text, boolean noBackground, boolean textBlack, int wantedTextSize) {
        SimpleImageGridFont exactMatch = null;
        if (wantedTextSize <= 7) {
            exactMatch = this.f6;
        } else if (wantedTextSize <= 15) {
            exactMatch = this.f8;
        } else if (wantedTextSize <= 31) {
            exactMatch = this.f16;
        }
        if (exactMatch != null) {
            if (noBackground) {
                int c = textBlack ? 0 : 255;
                exactMatch.drawLine(igd, x, y + exactMatch.getContentHeight(), text, c, c, c, 255);
            } else {
                exactMatch.drawLAB(igd, x, y + exactMatch.getContentHeight(), text, textBlack);
            }
            return;
        }
        SimpleImageGridFont font = this.f16;
        int scale = wantedTextSize / 16;
        int charWidth = font.charWidth * scale;
        int charHeight = font.charHeight * scale;
        int len = text.length();
        int advance = font.advance * scale;
        if (!noBackground) {
            int textTotalW = SimpleImageGridFont.measureLineCommon(advance, charWidth, len, false);
            int cc = textBlack ? 255 : 0;
            ImageRenderedTextChunk.background(igd, x, y, textTotalW, charHeight, 1, cc, cc, cc, 255);
        }
        float c = textBlack ? 0.0f : 1.0f;
        for (int i = 0; i < len; ++i) {
            char chr = text.charAt(i);
            if (chr >= '\u0100') {
                chr = '\u0000';
            }
            int srcx = font.charWidth * (chr % font.charsPerRow);
            int srcy = font.charHeight * (chr / font.charsPerRow);
            igd.drawScaledColoured(srcx, srcy, 7.0f, 14.0f, x, y, charWidth, charHeight, font.fontWhite, c, c, c, 1.0f);
            x += advance;
        }
    }

    @Override
    @NonNull
    public IFixedSizeFont derive(int lineHeight, int style) {
        if (lineHeight >= 16) {
            return this.f16;
        }
        if (lineHeight >= 8) {
            return this.f8;
        }
        return this.f6;
    }
}

