/*
 * Decompiled with CFR 0.152.
 */
package gabien.render;

import gabien.GaBIEn;
import gabien.backend.IGaBIEn;
import gabien.render.IImage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class WSIImage {
    public final int width;
    public final int height;

    public WSIImage(IGaBIEn backend, int w, int h) {
        GaBIEn.verify(backend);
        this.width = w;
        this.height = h;
    }

    public abstract void getPixels(@NonNull int[] var1);

    @NonNull
    public final int[] getPixels() {
        int[] res = new int[this.width * this.height];
        this.getPixels(res);
        return res;
    }

    @NonNull
    public abstract byte[] createPNG();

    @NonNull
    public final IImage upload() {
        return this.upload(null);
    }

    @NonNull
    public final IImage upload(@Nullable String debugId) {
        int[] tmp = new int[this.width * this.height];
        this.getPixels(tmp);
        return GaBIEn.createImage(debugId, tmp, this.width, this.height);
    }

    public static abstract class RW
    extends WSIImage {
        public RW(IGaBIEn backend, int w, int h) {
            super(backend, w, h);
        }

        public abstract void setPixels(@NonNull int[] var1);
    }
}

