/*
 * Decompiled with CFR 0.152.
 */
package gabien.render;

import gabien.render.IImage;
import gabien.render.IImgRegion;
import gabien.render.ITexRegion;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ReplicatedTexRegion
implements ITexRegion {
    private IImgRegion[] regions = new IImgRegion[0];
    public final float width;
    public final float height;

    public ReplicatedTexRegion(float w, float h) {
        this.width = w;
        this.height = h;
    }

    public synchronized void addRegion(IImgRegion n) {
        IImgRegion[] last = this.regions;
        this.regions = new IImgRegion[last.length + 1];
        System.arraycopy(last, 0, this.regions, 0, last.length);
        this.regions[last.length] = n;
    }

    @Override
    public float getRegionWidth() {
        return this.width;
    }

    @Override
    public float getRegionHeight() {
        return this.height;
    }

    @Override
    public IImgRegion pickImgRegion(@Nullable IImage lastSurface) {
        IImgRegion[] rs = this.regions;
        if (lastSurface != null) {
            for (IImgRegion itr : rs) {
                if (itr.getSurface() != lastSurface) continue;
                return itr;
            }
        }
        return this.regions[0];
    }

    @Override
    @NonNull
    public ReplicatedTexRegion subRegion(float x, float y, float w, float h) {
        ReplicatedTexRegion res = new ReplicatedTexRegion(w, h);
        res.regions = new IImgRegion[this.regions.length];
        for (int i = 0; i < this.regions.length; ++i) {
            res.regions[i] = this.regions[i].subRegion(x, y, w, h);
        }
        return res;
    }
}

