/*
 * Decompiled with CFR 0.152.
 */
package gabien.render;

import gabien.GaBIEn;
import gabien.natives.BadGPU;
import gabien.render.IImage;
import gabien.vopeks.VopeksImage;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.Nullable;

public abstract class RenderTarget
extends IImage {
    private final ArrayList<IImage> referencedBy = new ArrayList();

    public RenderTarget(@Nullable String id, int w, int h) {
        super(id, w, h);
    }

    public abstract void generateMipmap();

    protected final synchronized void batchReferenceBarrier() {
        while (!this.referencedBy.isEmpty()) {
            this.referencedBy.remove(this.referencedBy.size() - 1).batchFlush();
        }
    }

    @Override
    public final synchronized void batchReference(IImage caller) {
        this.batchFlush();
        this.referencedBy.add(caller);
    }

    @Override
    public final synchronized void batchUnreference(IImage caller) {
        this.referencedBy.remove(caller);
    }

    public abstract void shutdown();

    @Nullable
    public final BadGPU.Texture releaseTextureCustodyFromTask() {
        BadGPU.Texture tex = this.texture;
        this.texture = null;
        return tex;
    }

    public final synchronized IImage convertToImmutable(@Nullable String debugId) {
        this.batchFlush();
        VopeksImage res = new VopeksImage(GaBIEn.vopeks, debugId, this.getWidth(), this.getHeight(), consumer -> GaBIEn.vopeks.putTask(instance -> consumer.accept(this.releaseTextureCustodyFromTask())));
        this.shutdown();
        return res;
    }
}

