/*
 * Decompiled with CFR 0.152.
 */
package gabien.render;

import gabien.render.IImage;
import gabien.render.IImgRegion;
import org.eclipse.jdt.annotation.NonNull;

public final class ImageTexRegion
implements IImgRegion {
    @NonNull
    public final IImage base;
    public final float x;
    public final float y;
    public final float w;
    public final float h;
    public final float sW;
    public final float sH;

    public ImageTexRegion(IImage base, float x, float y, float w, float h, float sW, float sH) {
        this.base = base;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.sW = sW;
        this.sH = sH;
    }

    @Override
    public float getRegionWidth() {
        return this.w;
    }

    @Override
    public float getRegionHeight() {
        return this.h;
    }

    @Override
    public float getS(float x, float y) {
        return (this.x + x) / this.sW;
    }

    @Override
    public float getT(float x, float y) {
        return (this.y + y) / this.sH;
    }

    @Override
    @NonNull
    public IImage getSurface() {
        return this.base.getSurface();
    }

    @Override
    @NonNull
    public ImageTexRegion subRegion(float x, float y, float w, float h) {
        return new ImageTexRegion(this.base, this.x + x, this.y + y, w, h, this.sW, this.sH);
    }
}

