/*
 * Decompiled with CFR 0.152.
 */
package gabien.render;

import gabien.GaBIEn;
import gabien.natives.BadGPU;
import gabien.natives.BadGPUEnum;
import gabien.natives.BadGPUUnsafe;
import gabien.render.IImgRegion;
import gabien.render.ImageTexRegion;
import gabien.render.WSIImage;
import java.util.concurrent.Semaphore;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class IImage
implements IImgRegion {
    public final int width;
    public final int height;
    protected BadGPU.Texture texture;
    @NonNull
    public final String debugId;

    public IImage(@Nullable String id, int w, int h) {
        this.width = w;
        this.height = h;
        this.debugId = id == null ? super.toString() : super.toString() + ":" + id;
    }

    public final String toString() {
        return this.debugId;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @Override
    public final float getRegionWidth() {
        return this.width;
    }

    @Override
    public final float getRegionHeight() {
        return this.height;
    }

    @NonNull
    public final int[] getPixels() {
        int[] res = new int[this.width * this.height];
        this.getPixels(res);
        return res;
    }

    public final void getPixels(@NonNull int[] buffer) {
        this.getSurface().batchFlush();
        Semaphore sm = new Semaphore(1);
        sm.acquireUninterruptibly();
        this.getPixelsAsync(buffer, () -> sm.release());
        sm.acquireUninterruptibly();
    }

    public final void getPixelsAsync(@NonNull int[] buffer, @NonNull Runnable onDone) {
        this.getPixelsAsync(0, 0, this.width, this.height, BadGPUEnum.TextureLoadFormat.RGBA8888, buffer, 0, () -> {
            BadGPUUnsafe.pixelsConvertRGBA8888ToARGBI32InPlaceI(this.width, this.height, buffer, 0);
            BadGPUUnsafe.pixelsConvertARGBI32PremultipliedToStraightInPlaceI(this.width, this.height, buffer, 0);
            onDone.run();
        });
    }

    public abstract void getPixelsAsync(int var1, int var2, int var3, int var4, BadGPUEnum.TextureLoadFormat var5, @NonNull int[] var6, int var7, @NonNull Runnable var8);

    public abstract void getPixelsAsync(int var1, int var2, int var3, int var4, BadGPUEnum.TextureLoadFormat var5, @NonNull byte[] var6, int var7, @NonNull Runnable var8);

    @NonNull
    public final WSIImage.RW download() {
        return GaBIEn.createWSIImage(this.getPixels(), this.width, this.height);
    }

    @NonNull
    public final byte[] createPNG() {
        return this.download().createPNG();
    }

    public abstract void batchFlush();

    public abstract void batchReference(IImage var1);

    public abstract void batchUnreference(IImage var1);

    @Nullable
    public final BadGPU.Texture getTextureFromTask() {
        return this.texture;
    }

    @Override
    public final float getS(float x, float y) {
        return x / (float)this.width;
    }

    @Override
    public final float getT(float x, float y) {
        return y / (float)this.height;
    }

    @Override
    @NonNull
    public final IImage getSurface() {
        return this;
    }

    @Override
    @NonNull
    public final IImgRegion subRegion(float x, float y, float w, float h) {
        return new ImageTexRegion(this, x, y, w, h, this.width, this.height);
    }

    public boolean areContentsZeroAlpha() {
        int[] gp = this.getPixels();
        for (int i = 0; i < gp.length; ++i) {
            if ((gp[i] & 0xFF000000) == 0) continue;
            return false;
        }
        return true;
    }
}

